/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaTypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping<A extends Annotation>
extends AbstractJavaJpaContextNode
implements JavaTypeMapping {
    protected final A mappingAnnotation;

    protected AbstractJavaTypeMapping(JavaPersistentType parent, A mappingAnnotation) {
        super(parent);
        this.mappingAnnotation = mappingAnnotation;
    }

    @Override
    public JavaPersistentType getParent() {
        return (JavaPersistentType)super.getParent();
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return this.getPersistentType().getResourcePersistentType();
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    public A getMappingAnnotation() {
        return this.mappingAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public Iterator<ReadOnlyTable> associatedTables() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<ReadOnlyTable> allAssociatedTables() {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allAssociatedTableNames() {
        return EmptyIterator.instance();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public Iterator<TypeMapping> inheritanceHierarchy() {
        return this.convertToMappings(this.getPersistentType().inheritanceHierarchy());
    }

    protected Iterable<TypeMapping> getInheritanceHierarchy() {
        return CollectionTools.iterable(this.inheritanceHierarchy());
    }

    protected Iterator<TypeMapping> ancestors() {
        return this.convertToMappings(this.getPersistentType().ancestors());
    }

    protected Iterable<TypeMapping> getAncestors() {
        return CollectionTools.iterable(this.ancestors());
    }

    protected Iterator<TypeMapping> convertToMappings(Iterator<PersistentType> types) {
        return new TransformationIterator<PersistentType, TypeMapping>(types){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<JavaAttributeMapping> attributeMappings() {
        return new TransformationIterator<JavaPersistentAttribute, JavaAttributeMapping>(this.getPersistentType().attributes()){

            protected JavaAttributeMapping transform(JavaPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public Iterable<JavaAttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<JavaAttributeMapping>((Iterable)CollectionTools.collection(this.attributeMappings())){

            protected boolean accept(JavaAttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public Iterator<AttributeMapping> allAttributeMappings() {
        return new CompositeIterator(this.allAttributeMappingsLists());
    }

    protected Iterator<Iterator<AttributeMapping>> allAttributeMappingsLists() {
        return new TransformationIterator(this.nonNullInheritanceHierarchy(), TypeMappingTools.ATTRIBUTE_MAPPINGS_TRANSFORMER);
    }

    protected Iterator<TypeMapping> nonNullInheritanceHierarchy() {
        return new FilteringIterator(this.inheritanceHierarchy(), NotNullFilter.instance());
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.allAttributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return new CompositeIterator(this.overridableAttributeNamesLists());
    }

    protected Iterator<Iterator<String>> overridableAttributeNamesLists() {
        return new TransformationIterator(this.attributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator(this.allOverridableAttributeNamesLists());
    }

    protected Iterator<Iterator<String>> allOverridableAttributeNamesLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Column column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return new CompositeIterator(this.overridableAssociationNamesLists());
    }

    protected Iterator<Iterator<String>> overridableAssociationNamesLists() {
        return new TransformationIterator(this.attributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator(this.allOverridableAssociationNamesLists());
    }

    protected Iterator<Iterator<String>> allOverridableAssociationNamesLists() {
        return new TransformationIterator(this.inheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Relationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateType(messages, reporter, astRoot);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildTypeMappingValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildTypeMappingValidator(CompilationUnit astRoot) {
        return new GenericTypeMappingValidator(this, this.getResourcePersistentType(), this.buildTextRangeResolver(astRoot));
    }

    protected TypeMappingTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaTypeMappingTextRangeResolver(this, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.mappingAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentType().getValidationTextRange(astRoot);
    }
}

