/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.command;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class CheckForServiceProjectCommand
extends AbstractDataModelOperation {
    String clientProjectName;
    String wsdlURI;
    WebServicesParser webServicesParser;

    public void setClientProjectName(String name) {
        this.clientProjectName = name;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.clientProjectName == null || this.wsdlURI == null || this.wsdlURI.length() == 0 || this.webServicesParser == null) {
            return status;
        }
        if (this.clientProjectName == null || this.clientProjectName.length() == 0) {
            return status;
        }
        ValidationUtils vu = new ValidationUtils();
        IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName);
        boolean isServiceProject = vu.isProjectServiceProject(clientProject, this.wsdlURI, this.webServicesParser);
        if (isServiceProject) {
            IStatus wStatus = StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_WARN_IS_SERVICE_PROJECT, (Object[])new String[]{this.clientProjectName}));
            try {
                environment.getStatusHandler().report(wStatus);
            }
            catch (StatusException statusException) {
                IStatus eStatus = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_USER_ABORTED);
                return eStatus;
            }
        }
        return status;
    }
}

