/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.preferences.ui;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.ui.AbstractValidationSettingsPage;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;

public class HTMLValidationPreferencePage
extends AbstractValidationSettingsPage {
    private static final int[] SEVERITIES = new int[]{1, 2, -1};
    private static final String SETTINGS_SECTION_NAME = "HTMLValidationSeverities";
    private PixelConverter fPixelConverter;

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        page.setLayout((Layout)layout);
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite content = this.createValidationSection(page);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        content.setLayoutData((Object)gridData);
        return page;
    }

    private Composite createValidationSection(Composite page) {
        int nColumns = 3;
        ScrolledPageContent spContent = new ScrolledPageContent(page);
        Composite composite = spContent.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 0);
        description.setText(HTMLUIMessages.Validation_description);
        description.setFont(page.getFont());
        String[] errorWarningIgnoreLabel = new String[]{HTMLUIMessages.Validation_Error, HTMLUIMessages.Validation_Warning, HTMLUIMessages.Validation_Ignore};
        ExpandableComposite ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_elements, nColumns);
        Composite inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        String label = HTMLUIMessages.HTMLValidationPreferencePage_8;
        this.addComboBox(inner, label, "elemUnknownName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_9;
        this.addComboBox(inner, label, "elemInvalidName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_10;
        this.addComboBox(inner, label, "elemStartInvalidCase", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_11;
        this.addComboBox(inner, label, "elemEndInvalidCase", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_12;
        this.addComboBox(inner, label, "elemMissingStart", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_13;
        this.addComboBox(inner, label, "elemMissingEnd", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_14;
        this.addComboBox(inner, label, "elemUnnecessaryEnd", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_15;
        this.addComboBox(inner, label, "elemInvalidDirective", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_16;
        this.addComboBox(inner, label, "elemInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_17;
        this.addComboBox(inner, label, "elemDuplicate", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_18;
        this.addComboBox(inner, label, "elemCoexistence", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_19;
        this.addComboBox(inner, label, "elemUnclosedStartTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_20;
        this.addComboBox(inner, label, "elemUnclosedEndTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_21;
        this.addComboBox(inner, label, "elemInvalidEmptyTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_attributes, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_0;
        this.addComboBox(inner, label, "attrUndefName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_1;
        this.addComboBox(inner, label, "attrUndefValue", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_2;
        this.addComboBox(inner, label, "attrNameMismatch", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_3;
        this.addComboBox(inner, label, "attrInvalidName", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_4;
        this.addComboBox(inner, label, "attrInvalidValue", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_5;
        this.addComboBox(inner, label, "attrDuplicate", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_6;
        this.addComboBox(inner, label, "attrValueMismatch", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_7;
        this.addComboBox(inner, label, "attrValueUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_35;
        this.addComboBox(inner, label, "resourceNotFound", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_document_type, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_22;
        this.addComboBox(inner, label, "docDuplicateTag", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_23;
        this.addComboBox(inner, label, "docInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_24;
        this.addComboBox(inner, label, "docDoctypeUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_comment, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_27;
        this.addComboBox(inner, label, "commentInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_28;
        this.addComboBox(inner, label, "commentUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_cdata, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_29;
        this.addComboBox(inner, label, "cdataInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_30;
        this.addComboBox(inner, label, "cdataUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_pi, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_31;
        this.addComboBox(inner, label, "piInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_32;
        this.addComboBox(inner, label, "piUnclosed", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_entity_ref, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_33;
        this.addComboBox(inner, label, "refInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_34;
        this.addComboBox(inner, label, "piUndefined", SEVERITIES, errorWarningIgnoreLabel, 0);
        ec = this.createStyleSection(composite, HTMLUIMessages.Expandable_label_text, nColumns);
        inner = new Composite((Composite)ec, 0);
        inner.setFont(composite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        ec.setClient((Control)inner);
        label = HTMLUIMessages.HTMLValidationPreferencePage_25;
        this.addComboBox(inner, label, "docInvalidContent", SEVERITIES, errorWarningIgnoreLabel, 0);
        label = HTMLUIMessages.HTMLValidationPreferencePage_26;
        this.addComboBox(inner, label, "docInvalidChar", SEVERITIES, errorWarningIgnoreLabel, 0);
        this.restoreSectionExpansionStates(this.getDialogSettings().getSection(SETTINGS_SECTION_NAME));
        return spContent;
    }

    protected void performDefaults() {
        this.resetSeverities();
        super.performDefaults();
    }

    protected IDialogSettings getDialogSettings() {
        return HTMLUIPlugin.getDefault().getDialogSettings();
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    protected String getQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return "org.eclipse.wst.html.ui.preferences.validation";
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.wst.html.ui.propertyPage.project.validation";
    }

    public void init(IWorkbench workbench) {
    }
}

