/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttributeHandler;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMNodeNamedMapAdapter
implements Map<String, ITagAttributeHandler> {
    private static final long serialVersionUID = -4188412823197830484L;
    private final transient TLDElementDeclaration _tldElement;
    private final transient IAttributeAdvisor _advisor;
    private final transient AtomicBoolean _isInitialized = new AtomicBoolean(false);
    private final Map<String, ITagAttributeHandler> _cache;

    public CMNodeNamedMapAdapter(TLDElementDeclaration tldDoc, IAttributeAdvisor advisor) {
        this._tldElement = tldDoc;
        this._advisor = advisor;
        this._cache = new HashMap<String, ITagAttributeHandler>();
    }

    @Override
    public boolean containsKey(Object key) {
        this.ensureAllAttributes();
        return this._cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.ensureAllAttributes();
        return this._cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, ITagAttributeHandler>> entrySet() {
        this.ensureAllAttributes();
        return this._cache.entrySet();
    }

    @Override
    public ITagAttributeHandler get(Object key) {
        if (key instanceof String) {
            return this.getOrCreateAttribute((String)key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        this.ensureAllAttributes();
        return Collections.unmodifiableSet(this._cache.keySet());
    }

    @Override
    public int size() {
        if (this._tldElement != null) {
            return this._tldElement.getAttributes().getLength();
        }
        return this._cache.size();
    }

    @Override
    public Collection<ITagAttributeHandler> values() {
        this.ensureAllAttributes();
        return Collections.unmodifiableCollection(this._cache.values());
    }

    private synchronized ITagAttributeHandler getOrCreateAttribute(String name) {
        ITagAttributeHandler tagAttr = this._cache.get(name);
        if (tagAttr == null) {
            try {
                tagAttr = this._advisor.createAttributeHandler(name);
                this._cache.put(name, tagAttr);
            }
            catch (IAttributeAdvisor.UnknownAttributeException e) {
                JSFCorePlugin.log(e, "Trying to get attribute for " + name);
            }
        }
        return tagAttr;
    }

    private void ensureAllAttributes() {
        if (this._isInitialized.compareAndSet(false, true)) {
            for (CMAttributeDeclaration attrDecl : this._tldElement.getAttributes()) {
                this.getOrCreateAttribute(attrDecl.getAttrName());
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public ITagAttributeHandler put(String key, ITagAttributeHandler value) {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ITagAttributeHandler> t) {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public ITagAttributeHandler remove(Object key) {
        throw new UnsupportedOperationException("Cannot modify map");
    }
}

