/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class JavaEditorTextHoverProxy
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    private JavaEditorTextHoverDescriptor fHoverDescriptor;
    private IJavaEditorTextHover fHover;

    public JavaEditorTextHoverProxy(JavaEditorTextHoverDescriptor descriptor, IEditorPart editor) {
        this.fHoverDescriptor = descriptor;
        this.setEditor(editor);
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null) {
            this.fHover.setEditor(this.getEditor());
        }
        return this.isCreated();
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fHover).getHoverControlCreator();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

