/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.internal.utility.iterators.ChainIterator;
import org.eclipse.dali.orm.DiscriminatorColumn;
import org.eclipse.dali.orm.DiscriminatorValue;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.InheritanceType;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.PrimaryKeyJoinColumn;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IInheritanceModelAdapter;
import org.eclipse.dali.orm.impl.PersistenceSourceRefElementImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class InheritanceImpl
extends PersistenceSourceRefElementImpl
implements Inheritance {
    protected static final InheritanceType STRATEGY_EDEFAULT = InheritanceType.DEFAULT_LITERAL;
    protected InheritanceType strategy = STRATEGY_EDEFAULT;
    protected DiscriminatorColumn discriminatorColumn = null;
    protected DiscriminatorValue discriminatorValue = null;
    protected EList primaryKeyJoinColumns = null;
    protected static final boolean DEFAULT_PRIMARY_KEY_JOIN_COLUMNS_EDEFAULT = true;
    protected boolean defaultPrimaryKeyJoinColumns = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected InheritanceImpl() {
    }

    protected InheritanceImpl(IInheritanceModelAdapter modelAdapter) {
        super(modelAdapter);
        this.discriminatorColumn = OrmFactory.eINSTANCE.createDiscriminatorColumn(modelAdapter.createDiscriminatorColumnModelAdapter());
        ((InternalEObject)this.discriminatorColumn).eInverseAdd((InternalEObject)this, -2, null, null);
        this.discriminatorValue = OrmFactory.eINSTANCE.createDiscriminatorValue(modelAdapter.createDiscriminatorValueModelAdapter());
        ((InternalEObject)this.discriminatorValue).eInverseAdd((InternalEObject)this, -3, null, null);
        this.eAdapters().add((Object)this.buildPrimaryKeyJoinColumnsAdatper());
    }

    private Adapter buildPrimaryKeyJoinColumnsAdatper() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dali.orm.Inheritance");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (notification.getFeatureID((Class)clazz) == 3) {
                    if (notification.getEventType() == 3) {
                        ((IInheritanceModelAdapter)InheritanceImpl.this.getModelAdapter()).primaryKeyJoinColumnAdded();
                    } else if (notification.getEventType() == 4) {
                        ((IInheritanceModelAdapter)InheritanceImpl.this.getModelAdapter()).primaryKeyJoinColumnRemoved(notification.getPosition());
                    }
                }
            }
        };
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.INHERITANCE;
    }

    public InheritanceType getStrategy() {
        return this.strategy;
    }

    public void setStrategyGen(InheritanceType newStrategy) {
        InheritanceType oldStrategy = this.strategy;
        InheritanceType inheritanceType = this.strategy = newStrategy == null ? STRATEGY_EDEFAULT : newStrategy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldStrategy, (Object)this.strategy));
        }
    }

    public void setStrategy(InheritanceType newStrategy) {
        this.setStrategyGen(newStrategy);
        ((IInheritanceModelAdapter)this.getModelAdapter()).strategyChanged();
    }

    public DiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public NotificationChain basicSetDiscriminatorColumn(DiscriminatorColumn newDiscriminatorColumn, NotificationChain msgs) {
        DiscriminatorColumn oldDiscriminatorColumn = this.discriminatorColumn;
        this.discriminatorColumn = newDiscriminatorColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDiscriminatorColumn, (Object)newDiscriminatorColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public DiscriminatorValue getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public NotificationChain basicSetDiscriminatorValue(DiscriminatorValue newDiscriminatorValue, NotificationChain msgs) {
        DiscriminatorValue oldDiscriminatorValue = this.discriminatorValue;
        this.discriminatorValue = newDiscriminatorValue;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDiscriminatorValue, (Object)newDiscriminatorValue);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public EList getPrimaryKeyJoinColumns() {
        if (this.primaryKeyJoinColumns == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.dali.orm.PrimaryKeyJoinColumn");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.primaryKeyJoinColumns = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 3);
        }
        return this.primaryKeyJoinColumns;
    }

    public boolean isDefaultPrimaryKeyJoinColumns() {
        return this.defaultPrimaryKeyJoinColumns;
    }

    public void setDefaultPrimaryKeyJoinColumnsGen(boolean newDefaultPrimaryKeyJoinColumns) {
        boolean oldDefaultPrimaryKeyJoinColumns = this.defaultPrimaryKeyJoinColumns;
        this.defaultPrimaryKeyJoinColumns = newDefaultPrimaryKeyJoinColumns;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldDefaultPrimaryKeyJoinColumns, this.defaultPrimaryKeyJoinColumns));
        }
    }

    public void setDefaultPrimaryKeyJoinColumns(boolean newDefaultPrimaryKeyJoinColumns) {
        this.setDefaultPrimaryKeyJoinColumnsGen(newDefaultPrimaryKeyJoinColumns);
        ((IInheritanceModelAdapter)this.getModelAdapter()).defaultPrimaryKeyJoinColumnsChanged();
    }

    public Entity rootEntity() {
        Entity rootEntity;
        PersistentType parentPersistentType;
        TypeMapping owningTypeMapping = this.getOwningTypeMapping();
        Entity possibleRootEntity = null;
        if (owningTypeMapping.getKey() == Entity.Key.INSTANCE) {
            possibleRootEntity = (Entity)owningTypeMapping;
        }
        if ((parentPersistentType = owningTypeMapping.getPersistentType().getParentPersistentType()) != null && (rootEntity = parentPersistentType.getTypeMapping().getInheritance().rootEntity()) != null) {
            possibleRootEntity = rootEntity;
        }
        return possibleRootEntity;
    }

    public TypeMapping parentTypeMapping() {
        PersistentType parentPersistentType = this.getOwningTypeMapping().getPersistentType().getParentPersistentType();
        if (parentPersistentType != null) {
            return parentPersistentType.getTypeMapping();
        }
        return null;
    }

    public Entity parentEntity() {
        TypeMapping owningTypeMapping = this.getOwningTypeMapping();
        Iterator i = this.typeMappingLineage();
        while (i.hasNext()) {
            TypeMapping typeMapping = (TypeMapping)i.next();
            if (typeMapping == owningTypeMapping || typeMapping.getKey() != Entity.Key.INSTANCE) continue;
            return (Entity)typeMapping;
        }
        return (Entity)owningTypeMapping;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetDiscriminatorColumn(null, msgs);
            }
            case 2: {
                return this.basicSetDiscriminatorValue(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getPrimaryKeyJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStrategy();
            }
            case 1: {
                return this.getDiscriminatorColumn();
            }
            case 2: {
                return this.getDiscriminatorValue();
            }
            case 3: {
                return this.getPrimaryKeyJoinColumns();
            }
            case 4: {
                return this.isDefaultPrimaryKeyJoinColumns() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setStrategy((InheritanceType)((Object)newValue));
                return;
            }
            case 3: {
                this.getPrimaryKeyJoinColumns().clear();
                this.getPrimaryKeyJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setDefaultPrimaryKeyJoinColumns((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setStrategy(STRATEGY_EDEFAULT);
                return;
            }
            case 3: {
                this.getPrimaryKeyJoinColumns().clear();
                return;
            }
            case 4: {
                this.setDefaultPrimaryKeyJoinColumns(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.strategy != STRATEGY_EDEFAULT;
            }
            case 1: {
                return this.discriminatorColumn != null;
            }
            case 2: {
                return this.discriminatorValue != null;
            }
            case 3: {
                return this.primaryKeyJoinColumns != null && !this.primaryKeyJoinColumns.isEmpty();
            }
            case 4: {
                return !this.defaultPrimaryKeyJoinColumns;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (strategy: ");
        result.append((Object)this.strategy);
        result.append(", defaultPrimaryKeyJoinColumns: ");
        result.append(this.defaultPrimaryKeyJoinColumns);
        result.append(')');
        return result.toString();
    }

    public boolean specifyDiscriminatorValue() {
        return ((IInheritanceModelAdapter)this.getModelAdapter()).specifyDiscriminatorValue();
    }

    public Iterator typeMappingLineage() {
        return new ChainIterator(this.getOwningTypeMapping()){

            protected Object nextLink(Object currentLink) {
                return ((TypeMapping)currentLink).getInheritance().parentTypeMapping();
            }
        };
    }

    public TypeMapping getOwningTypeMapping() {
        return (TypeMapping)this.getParent();
    }

    public void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        if (this.rootEntity() != this.getOwningTypeMapping() && this.strategy == InheritanceType.JOINED_LITERAL) {
            Iterator stream = this.getPrimaryKeyJoinColumns().iterator();
            while (stream.hasNext()) {
                ((PrimaryKeyJoinColumn)stream.next()).addProblemsTo(problems);
            }
        }
    }
}

