/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.SequenceGenerator;
import org.eclipse.dali.orm.TableGenerator;
import org.eclipse.dali.orm.Temporal;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.IIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.ISequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.ITableGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.ITemporalModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaSequenceGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableGeneratorModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTemporalModelAdapter;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.QualifiedName;

public class JavaIdMappingModelAdapter
extends JavaAttributeMappingModelAdapter
implements IIdMappingModelAdapter {
    public static final String ANNOTATION_NAME = "Id";
    public static final String GENERATED_VALUE_ANNOTATION = "GeneratedValue";
    public static final String TABLE_GENERATOR_ANNOTATION = "TableGenerator";
    public static final String SEQUENCE_GENERATOR_ANNOTATION = "SequenceGenerator";

    public IColumnModelAdapter createColumnModelAdapter() {
        return new JavaColumnModelAdapter(this.getAttribute(), this.buildColumnOwner());
    }

    private IColumnModelAdapter.ColumnOwner buildColumnOwner() {
        return new IColumnModelAdapter.ColumnOwner(){

            public Table getTableNamed(String tableName) {
                return this.getTypeMapping().getResolvedDBTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return JavaIdMappingModelAdapter.this.getIdMapping().getTypeMapping();
            }

            public ITextRange getTextRange() {
                return JavaIdMappingModelAdapter.this.getAttributeMapping().getTextRange();
            }
        };
    }

    public IGeneratedValueModelAdapter createGeneratedValueModelAdapter() {
        return new JavaGeneratedValueModelAdapter(this.getAttribute());
    }

    public ITemporalModelAdapter createTemporalModelAdapter(String temporalTypeName) {
        return new JavaTemporalModelAdapter(this.getAttribute(), temporalTypeName);
    }

    public ITableGeneratorModelAdapter createTableGeneratorModelAdapter() {
        return new JavaTableGeneratorModelAdapter(this.getAttribute());
    }

    public ISequenceGeneratorModelAdapter createSequenceGeneratorModelAdapter() {
        return new JavaSequenceGeneratorModelAdapter(this.getAttribute());
    }

    protected AttributeMapping buildAttributeMapping(boolean isDefault) {
        return OrmFactory.eINSTANCE.createIdMapping(this);
    }

    public void generatedValueChanged() {
        this.updateJavaGeneratedValue();
    }

    public void tableGeneratorChanged() {
        this.updateJavaTableGenerator();
    }

    public void sequenceGeneratorChanged() {
        this.updateJavaSequenceGenerator();
    }

    public void temporalChanged() {
        this.updateJavaTemporal();
    }

    private void updateJavaTableGenerator() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        TableGenerator tableGenerator = this.getIdMapping().getTableGenerator();
        if (tableGenerator == null) {
            if (this.containsAnnotation(TABLE_GENERATOR_ANNOTATION, astRoot)) {
                this.getAttribute().removeAnnotation(TABLE_GENERATOR_ANNOTATION);
            }
        } else if (!this.containsAnnotation(TABLE_GENERATOR_ANNOTATION, astRoot)) {
            this.getAttribute().addAnnotation(TABLE_GENERATOR_ANNOTATION);
        }
    }

    private void updateJavaSequenceGenerator() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        SequenceGenerator sequenceGenerator = this.getIdMapping().getSequenceGenerator();
        if (sequenceGenerator == null) {
            if (this.containsAnnotation(SEQUENCE_GENERATOR_ANNOTATION, astRoot)) {
                this.getAttribute().removeAnnotation(SEQUENCE_GENERATOR_ANNOTATION);
            }
        } else if (!this.containsAnnotation(SEQUENCE_GENERATOR_ANNOTATION, astRoot)) {
            this.getAttribute().addAnnotation(SEQUENCE_GENERATOR_ANNOTATION);
        }
    }

    private void updateJavaGeneratedValue() {
        CompilationUnit astRoot = this.getAttribute().createASTRoot();
        GeneratedValue generatedValue = this.getIdMapping().getGeneratedValue();
        if (generatedValue == null) {
            if (this.containsAnnotation(GENERATED_VALUE_ANNOTATION, astRoot)) {
                this.getAttribute().removeAnnotation(GENERATED_VALUE_ANNOTATION);
            }
        } else if (!this.containsAnnotation(GENERATED_VALUE_ANNOTATION, astRoot)) {
            this.getAttribute().addAnnotation(GENERATED_VALUE_ANNOTATION);
        }
    }

    private void updateJavaTemporal() {
        Temporal temporal = this.getIdMapping().getTemporal();
        Annotation annotation = this.getAttribute().getAnnotation("Temporal");
        if (temporal == null) {
            if (annotation != null) {
                this.getAttribute().removeAnnotation("Temporal");
            }
        } else if (annotation == null) {
            this.getAttribute().addAnnotation("Temporal");
        }
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.updatePersGeneratedValue(astRoot);
        this.updatePersTableGenerator(astRoot);
        this.updatePersSequenceGenerator(astRoot);
        this.updatePersColumn(astRoot);
        this.updatePersTemporal(astRoot);
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
        super.postUpdatePersModel(astRoot);
        this.getColumnModelAdapter().postUpdatePersModel(astRoot);
    }

    void updatePersTableGenerator(CompilationUnit astRoot) {
        Annotation annotation = this.getAttribute().getAnnotation(TABLE_GENERATOR_ANNOTATION, astRoot);
        TableGenerator tableGenerator = this.getIdMapping().getTableGenerator();
        if (annotation == null) {
            if (tableGenerator != null) {
                this.getIdMapping().setTableGenerator(null);
            }
        } else {
            if (tableGenerator == null) {
                ITableGeneratorModelAdapter tableGeneratorModelAdapter = this.createTableGeneratorModelAdapter();
                tableGenerator = OrmFactory.eINSTANCE.createTableGenerator(tableGeneratorModelAdapter);
                this.getIdMapping().setTableGenerator(tableGenerator);
            }
            this.getTableGeneratorModelAdapter().updatePersModel(astRoot);
        }
    }

    void updatePersSequenceGenerator(CompilationUnit astRoot) {
        Annotation annotation = this.getAttribute().getAnnotation(SEQUENCE_GENERATOR_ANNOTATION, astRoot);
        SequenceGenerator sequenceGenerator = this.getIdMapping().getSequenceGenerator();
        if (annotation == null) {
            if (sequenceGenerator != null) {
                this.getIdMapping().setSequenceGenerator(null);
            }
        } else {
            if (sequenceGenerator == null) {
                ISequenceGeneratorModelAdapter sequenceGeneratorModelAdapter = this.createSequenceGeneratorModelAdapter();
                sequenceGenerator = OrmFactory.eINSTANCE.createSequenceGenerator(sequenceGeneratorModelAdapter);
                this.getIdMapping().setSequenceGenerator(sequenceGenerator);
            }
            this.getSequenceGeneratorModelAdapter().updatePersModel(astRoot);
        }
    }

    private void updatePersColumn(CompilationUnit astRoot) {
        this.getColumnModelAdapter().updatePersModel(astRoot);
    }

    private void updatePersTemporal(CompilationUnit astRoot) {
        Annotation annotation = this.getAttribute().getAnnotation("Temporal", astRoot);
        Temporal temporal = this.getIdMapping().getTemporal();
        if (annotation == null) {
            if (temporal != null) {
                this.getIdMapping().setTemporal(null);
            }
        } else {
            Expression expression = ASTTools.element(annotation, "value");
            String string = null;
            if (expression != null && expression.getNodeType() == 40) {
                string = ((QualifiedName)expression).getName().getIdentifier();
            }
            if (temporal == null) {
                this.getIdMapping().setTemporal(this.createTemporalModelAdapter(string).getTemporal());
            }
            this.getTemporalModelAdapter().updatePersModel(astRoot);
        }
    }

    void updatePersGeneratedValue(CompilationUnit astRoot) {
        Annotation annotation = this.getAttribute().getAnnotation(GENERATED_VALUE_ANNOTATION, astRoot);
        GeneratedValue generatedValue = this.getIdMapping().getGeneratedValue();
        if (annotation == null) {
            if (generatedValue != null) {
                this.getIdMapping().setGeneratedValue(null);
            }
        } else {
            if (generatedValue == null) {
                IGeneratedValueModelAdapter generatedValueModelAdapter = this.createGeneratedValueModelAdapter();
                generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
                this.getIdMapping().setGeneratedValue(generatedValue);
            }
            this.getGeneratedValueModelAdapter().updatePersModel(astRoot);
        }
    }

    private JavaGeneratedValueModelAdapter getGeneratedValueModelAdapter() {
        return (JavaGeneratedValueModelAdapter)this.getIdMapping().getGeneratedValue().getModelAdapter();
    }

    private JavaTableGeneratorModelAdapter getTableGeneratorModelAdapter() {
        TableGenerator tableGenerator = this.getIdMapping().getTableGenerator();
        if (tableGenerator != null) {
            return (JavaTableGeneratorModelAdapter)tableGenerator.getModelAdapter();
        }
        return null;
    }

    private JavaSequenceGeneratorModelAdapter getSequenceGeneratorModelAdapter() {
        SequenceGenerator sequenceGenerator = this.getIdMapping().getSequenceGenerator();
        if (sequenceGenerator != null) {
            return (JavaSequenceGeneratorModelAdapter)sequenceGenerator.getModelAdapter();
        }
        return null;
    }

    private JavaTemporalModelAdapter getTemporalModelAdapter() {
        return (JavaTemporalModelAdapter)this.getIdMapping().getTemporal().getModelAdapter();
    }

    IdMapping getIdMapping() {
        return (IdMapping)this.getAttributeMapping();
    }

    private JavaColumnModelAdapter getColumnModelAdapter() {
        return (JavaColumnModelAdapter)this.getIdMapping().getColumn().getModelAdapter();
    }

    public String attributeMappingName() {
        return ANNOTATION_NAME;
    }
}

