/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.DiscriminatorType;
import org.eclipse.dali.orm.DiscriminatorValue;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Inheritance;
import org.eclipse.dali.orm.adapters.IDiscriminatorValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.Type;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaDiscriminatorValueModelAdapter
implements IDiscriminatorValueModelAdapter {
    private DiscriminatorValue discriminatorValue;
    private Type type;
    private StringAnnotationElementAdapter specifiedValueAnnotationElementAdapter;
    private static final String DISCRIMINATOR_VALUE_ANNOTATION_NAME = "DiscriminatorValue";

    public JavaDiscriminatorValueModelAdapter(Type type) {
        this.type = type;
        this.specifiedValueAnnotationElementAdapter = new StringAnnotationElementAdapter(this.buildValueAnnotationElementInfo());
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildValueAnnotationElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaDiscriminatorValueModelAdapter.this.discriminatorValue.setSpecifiedValue(newValue);
            }

            public String persValue() {
                return JavaDiscriminatorValueModelAdapter.this.discriminatorValue.getSpecifiedValue();
            }

            public Member member() {
                return JavaDiscriminatorValueModelAdapter.this.type();
            }

            public String defaultValue() {
                return null;
            }

            public String annotationName() {
                return JavaDiscriminatorValueModelAdapter.DISCRIMINATOR_VALUE_ANNOTATION_NAME;
            }

            public String annotationElementName() {
                return "value";
            }

            public boolean removeAnnotationIfEmpty() {
                return true;
            }
        };
    }

    protected Type type() {
        return this.type;
    }

    public void setDiscriminatorValue(DiscriminatorValue discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public ITextRange getTextRange() {
        return null;
    }

    public void specifiedValueChanged() {
        this.specifiedValueAnnotationElementAdapter.updateJavaElement();
    }

    public void updatePersModel(CompilationUnit astRoot) {
        this.specifiedValueAnnotationElementAdapter.updatePersElement(astRoot);
        this.updatePersDefaultValue(astRoot);
    }

    private Entity getEntity() {
        return (Entity)this.discriminatorValue.getParent().getParent();
    }

    protected void updatePersDefaultValue(CompilationUnit astRoot) {
        DiscriminatorType discriminatorType = ((Inheritance)this.discriminatorValue.getParent()).getDiscriminatorColumn().getDiscriminatorType();
        if (!(this.typeIsAbstract() || discriminatorType != DiscriminatorType.STRING_LITERAL && discriminatorType != DiscriminatorType.DEFAULT_LITERAL)) {
            String defaultValue = this.getEntity().getName();
            if (this.discriminatorValue.getDefaultValue() == null || !this.discriminatorValue.getDefaultValue().equals(defaultValue)) {
                this.discriminatorValue.setDefaultValue(defaultValue);
            }
        } else if (this.discriminatorValue.getDefaultValue() != null) {
            this.discriminatorValue.setDefaultValue(null);
        }
    }

    private boolean typeIsAbstract() {
        return this.type().isAbstract();
    }
}

