/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.Insertable;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.ColumnInfoAdapter;
import org.eclipse.dali.orm.adapters.java.Member;

public class ColumnInsertableInfo
implements AbstractAnnotationElementAdapter.AnnotationElementInfo {
    private final ColumnInfoAdapter adapter;

    public ColumnInsertableInfo(ColumnInfoAdapter adapter) {
        this.adapter = adapter;
    }

    public String annotationElementName() {
        return "insertable";
    }

    public String annotationName() {
        return "Column";
    }

    public String defaultValue() {
        return null;
    }

    public Member member() {
        return this.adapter.member();
    }

    public String persValue() {
        switch (this.column().getInsertable().getValue()) {
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
        }
        return null;
    }

    public boolean removeAnnotationIfEmpty() {
        return true;
    }

    public void setPersValue(String newValue) {
        if (newValue == null) {
            this.column().setInsertable(Insertable.DEFAULT_LITERAL);
        } else if (newValue.equals("true")) {
            this.column().setInsertable(Insertable.TRUE_LITERAL);
        } else if (newValue.equals("false")) {
            this.column().setInsertable(Insertable.FALSE_LITERAL);
        }
    }

    private Column column() {
        return this.adapter.column();
    }
}

