/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.core.nature;

import org.eclipse.jsr220orm.core.internal.product.OrmProject;

/**
 * The <code>OrmNatureEvent</code> provides specific contextual information
 * associated with canges to a OrmNatureEvent.
 */
public class OrmNatureEvent {

	private OrmProject ormProject;
	private OrmNature nature;

	/**
	 * Constructs a <code>OrmNatureEvent</code> object with the specified
	 * nature, and OrmProject.
	 */
	OrmNatureEvent(OrmNature nature, OrmProject ormProject) {
		super();
		this.ormProject = ormProject;
		this.nature = nature;
	}

    public OrmNature getNature() {
		return nature;
	}

    public OrmProject getOrmProject() {
        return ormProject;
    }
}
