/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.popup.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.ddl.DdlGenerator;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.metadata.EntityModel;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class GenerateDdlAction implements IObjectActionDelegate {

    private IProject project;
    
	/**
	 * Constructor for Action1.
	 */
	public GenerateDdlAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
	    try {
            OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
            OrmProject activeOrmProject = nature.getActiveOrmProject();
            IEntityModelManager modelManager = activeOrmProject.getModelManager();
//            Schema schema = nature.getActiveSchema();
            DatabaseDefinition dbDef = nature.getDatabaseDefinition();
            DdlGenerator ddlGenerator = new DdlGenerator(modelManager, dbDef); 
            Wizard wizard = new FEWizard(ddlGenerator.getCreateDDL());
            WizardDialog dialog = new WizardDialog(Display.getCurrent()
                    .getActiveShell(), wizard);
            dialog.create();
            dialog.open();
            Database database = nature.getActiveDatabase();
            if(database instanceof ICatalogObject){
                ((ICatalogObject)database).refresh();
            }
        } catch (Exception e) {
            OrmUiPlugin.logException(e, "Could not generate DDL", null);
        }
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
        project = (IProject) ((StructuredSelection)selection).getFirstElement();
	}

}
