/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping.composite;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.ui.internal.binding.AttMappedByBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EmfCheckButtonGroupBinding;
import org.eclipse.jsr220orm.ui.internal.binding.EmfWidgetBinding;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AttributeComposite{

	protected AttributeMetaData attributeMD;
    private Label lFetchType = null;
    private CCombo tFetchType = null;
    private Label lCascade = null;
    private EmfWidgetBinding fetchTypeBinding = new EmfWidgetBinding();
    private EmfWidgetBinding optionalBinding;
    private AttMappedByBinding mappedByBinding;
    private EmfCheckButtonGroupBinding cascadeBinding;
    private Composite composite;

    public AttributeComposite() {
    }
    
    public Composite createComposite(final Composite parent, FormToolkit toolkit, AdapterFactory adapterFactory) {
//        ScrolledForm scrolledForm = new ScrolledForm(section, SWT.V_SCROLL);
//        scrolledForm.setExpandHorizontal(true);
//        scrolledForm.setExpandVertical(true);
//        scrolledForm.setMinWidth(10);
//        toolkit.adapt(scrolledForm);
//        scrolledForm.getBody().setLayout(new FillLayout());
//        Composite composite = scrolledForm.getBody();
//        section.setClient(scrolledForm);
        composite = toolkit.createComposite(parent);
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = org.eclipse.swt.layout.GridData.END;
        GridData gridData2 = new GridData();
        gridData2.widthHint = 80;
        gridData2.horizontalSpan = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout(gridLayout);
        lFetchType = toolkit.createLabel(composite, "Fetch type");
        tFetchType = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        tFetchType.setData(FormToolkit.KEY_DRAW_BORDER, FormToolkit.TEXT_BORDER);
        fetchTypeBinding.bind(adapterFactory, tFetchType, MetadataPackage.ATTRIBUTE_META_DATA__FETCH_TYPE);
        tFetchType.setLayoutData(gridData2);
        tFetchType.setEditable(false);
        toolkit.adapt(tFetchType);
        if(canBeOptional()){
            addOptional(composite, toolkit, adapterFactory);
        }
        return composite;
    }

    public Composite getComposite() {
        return composite;
    }

	public AttributeMetaData getAttributeMetaData() {
		return attributeMD;
	}

	public void setAttributeMetaData(AttributeMetaData attributeMD) {
		this.attributeMD = attributeMD;
        fetchTypeBinding.setEObject(attributeMD);
        if(optionalBinding != null){
            optionalBinding.setEObject(attributeMD);
        }
        if(mappedByBinding != null){
            mappedByBinding.setEObject(attributeMD);
        }
        if(cascadeBinding != null){
            cascadeBinding.setEObject(attributeMD);
        }
	}
    
    protected boolean canBeOptional() {
        return true;
    }

    protected void addOptional(Composite composite, FormToolkit toolkit, AdapterFactory adapterFactory) {
        toolkit.createLabel(composite, "Optional");
        Button tOptional = toolkit.createButton(composite, "", SWT.CHECK);
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 3;
        tOptional.setLayoutData(gridData4);
        optionalBinding = new EmfWidgetBinding();
        optionalBinding.bind(adapterFactory, tOptional, MetadataPackage.ATTRIBUTE_META_DATA__OPTIONAL);
    }

    protected void addMappedBy(Composite composite, FormToolkit toolkit, AdapterFactory adapterFactory) {
        toolkit.createLabel(composite, "Mapped by");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        gridData2.horizontalAlignment = GridData.FILL;
        gridData2.grabExcessHorizontalSpace = true;
        CCombo tMappedBy = new CCombo(composite, SWT.BORDER | SWT.READ_ONLY);
        tMappedBy.setEditable(false);
        toolkit.adapt(tMappedBy);
        tMappedBy.setLayoutData(gridData2);
        tMappedBy.setEditable(false);
        mappedByBinding = new AttMappedByBinding();
        mappedByBinding.bind(adapterFactory, tMappedBy);
    }

    protected void addCascade(Composite composite, FormToolkit toolkit, AdapterFactory adapterFactory, int featureId) {
        toolkit.createLabel(composite, "Cascade on:");
        Composite cascade = toolkit.createComposite(composite, SWT.WRAP);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        cascade.setLayout(rowLayout);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 3;
        gridData1.horizontalAlignment = GridData.FILL;
        gridData1.grabExcessHorizontalSpace = true;
        cascade.setLayoutData(gridData1);
        cascadeBinding = new EmfCheckButtonGroupBinding(toolkit);
        cascadeBinding.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
        cascadeBinding.bind(adapterFactory, cascade, featureId);
    }
} 
