/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.views.MappingView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NewEntityComposite {

    private static final String ADD_CLASS = "addClass-";

    private static final String IMG = "img-";

    private FormText formText;

    private ICompilationUnit unit;

    private Form mainForm;

    private MappingView view;

    public NewEntityComposite(MappingView view) {
        this.view = view;
    }

    public Composite getComposite() {
        return mainForm;
    }

    public void setCompilationUnit(ICompilationUnit unit)
            throws JavaModelException {
        this.unit = unit;
        formText.setText(getText(unit), true, false);
    }

    public void createComposite(Composite parent, int style, FormToolkit toolkit) {
        mainForm = toolkit.createForm(parent);
        mainForm.setText("Class not Persistent");
        GridLayout gridLayout = new GridLayout();
        mainForm.getBody().setLayout(gridLayout);
        formText = toolkit.createFormText(mainForm.getBody(), true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        formText.setLayoutData(gridData);
        // formText.setImage("addClass",
        // OrmUiPlugin.getImageDescriptor("icons/memoryreset_tsk_002.gif").createImage());
        formText.addHyperlinkListener(new HyperlinkAdapter() {
            public void linkActivated(HyperlinkEvent e) {
                String href = (String) e.getHref();
                if (href.startsWith(ADD_CLASS)) {
                    String intStr = href.substring(ADD_CLASS.length());
                    addClass(unit, Integer.parseInt(intStr));
                }
            }
        });
    }

    private void addReachable(String string) {
        System.out.println("NewEntityComposite.addReachable(): " + string);
    }

    private void addClass(ICompilationUnit unit, int option) {
        IJavaProject javaProject = (IJavaProject) unit
                .getAncestor(IJavaElement.JAVA_PROJECT);
        IProject project = javaProject.getProject();
        String name = unit.findPrimaryType().getFullyQualifiedName();
        try {
            OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
            if (nature != null) {
                OrmProject activeOrmProject = nature.getActiveOrmProject();
                if (activeOrmProject != null) {
                    IEntityModelManager modelManager = activeOrmProject.getModelManager();
                    List mappings = modelManager.getPossibleEntityMappings(null);
                    IIntOption intOption = null;
                    for (Iterator it = mappings.iterator(); it.hasNext();) {
                        IIntOption tempOption = (IIntOption) it.next();
                        if(tempOption.getId() == option){
                            intOption = tempOption;
                            break;
                        }
    
                    }
                    modelManager.makePersistent(Collections .singleton(name), intOption);
                }
            }
        } catch (CoreException e) {
            OrmUiPlugin.logException(e, "Could not add class " + name, formText.getShell());
        }
//        view.doUpdate(true);
    }

    private String getText(ICompilationUnit unit) throws JavaModelException {
        IJavaProject javaProject = (IJavaProject) unit
                .getAncestor(IJavaElement.JAVA_PROJECT);
        IProject project = javaProject.getProject();
        String name = unit.findPrimaryType().getFullyQualifiedName();
        try {
            OrmNature nature = (OrmNature) project.getNature(OrmNature.ID);
            if (nature != null) {
                OrmProject activeOrmProject = nature.getActiveOrmProject();
                if (activeOrmProject != null) {
                    List mappings = activeOrmProject.getModelManager()
                            .getPossibleEntityMappings(null);
                    if (mappings.isEmpty()) {
                        return "No mapping for " + name;
                    }
                    StringBuffer buffer = new StringBuffer("<form>Make ");
                    buffer.append(name);
                    buffer.append(":\n\n");
                    for (Iterator it = mappings.iterator(); it.hasNext();) {
                        IIntOption option = (IIntOption) it.next();
                        buffer.append("<p><img href=\"");
                        buffer.append(IMG);
                        buffer.append(option.getId());
                        buffer.append("\"/> <a href=\"");
                        buffer.append(ADD_CLASS);
                        buffer.append(option.getId());
                        buffer.append("\">");
                        buffer.append(option.getText());
                        buffer.append("</a> ");
                        buffer.append(option.getTooltipText());
                        buffer.append("</p>\n");
                        Image image = ExtendedImageRegistry.INSTANCE.getImage(option.getImage());
                        if (image != null) {
                            formText.setImage(IMG + option.getId(), (Image) image);
                        }
                    }
                    buffer.append("</form>");
                    return buffer.toString();
                }
            }
        } catch (CoreException e) {
            OrmUiPlugin.logException(e, "Could not add class " + name, formText
                    .getShell());
        }
        return "No mapping for " + name;
    }
}
