/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.ui.internal.mapping.composite.EntityComposite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;

public class EntityBook {

    private EntityMetaData entityMetaData;
    private Form mainForm;
    private PageBook entityBook;
    private EntityComposite defaultPage;
    private FormToolkit toolkit;
    private Section section;
    
    public void createPartControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        mainForm = toolkit.createForm(parent);
        mainForm.getBody().setLayout(new GridLayout());
        section = toolkit.createSection(mainForm.getBody(), ExpandableComposite.TITLE_BAR);
        section.setText("Entity properties");
        section.setLayoutData(new GridData(GridData.FILL_BOTH));
        ScrolledForm scrolledForm = new ScrolledForm(section, SWT.V_SCROLL | SWT.VERTICAL);
        scrolledForm.setExpandHorizontal(true);
        scrolledForm.setExpandVertical(true);
        scrolledForm.setMinWidth(0);
        toolkit.adapt(scrolledForm);
        Composite composite = scrolledForm.getBody();
//        Composite composite = toolkit.createComposite(section, SWT.V_SCROLL);
        section.setClient(scrolledForm);
        composite.setLayout(new GridLayout());
        entityBook = new PageBook(composite, SWT.NONE);
        entityBook.setLayoutData(new GridData(GridData.FILL_BOTH));
        mainForm.getBody().layout();
    }

    public Composite getComposite() {
        return mainForm;
    }

    public EntityMetaData getEntityMetaData() {
        return entityMetaData;
    }

    public void setEntityMetaData(EntityMetaData entityMetaData) {
        this.entityMetaData = entityMetaData;
        entityBook.showPage(getEntityTab(entityMetaData));
        section.setText(entityMetaData.getClassName());
        section.layout();
        mainForm.layout();
  }

    private String getTile(EntityMetaData entityMetaData) {
        String schemaName = entityMetaData.getSchemaName();
        return schemaName != null ? schemaName : entityMetaData.getClassName();
    }

    protected Control getEntityTab(EntityMetaData entityMetaData) {
        // TODO turn into extention point
        return getDefualtPage(entityMetaData);
    }

    protected Control getDefualtPage(EntityMetaData entityMetaData) {
        if (defaultPage == null) {
            defaultPage = createDefaultPage();
        }
        defaultPage.setEntityMetaData(entityMetaData);
        return defaultPage.getComposite();
    }

    protected EntityComposite createDefaultPage() {
        EntityComposite entityComposite = new EntityComposite();
        entityComposite.createComposite(entityBook, toolkit);
        return entityComposite;
    }

}
