/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

package org.eclipse.jsr220orm.hibernate.internal.ui.config;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jsr220orm.hibernate.HibernatePlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

public class HibernateActivationPage extends WizardPage {

    private IProject project;
    private HibernateConfigComposite composite;
    
    public HibernateActivationPage(String pageName) {
        super(pageName);
        setTitle(pageName);
    }

    public void setIProject(IProject project) {
        this.project = project;
    }

    public void createControl(Composite parent) {
        composite = new HibernateConfigComposite(parent, SWT.NONE);
        try {
            composite.setIProject(project);
        } catch (Exception e) {
            HibernatePlugin.logException(e);
        }
        setControl(composite);
    }

    public boolean performFinish() {
        return composite.saveChanges();
    }

    public boolean canFinish() {
        return true;
    }
}