/*
 * Copyright (c) 2005 Versant Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Versant Corporation - initial API and implementation
 */

/**
 * <copyright>
 * </copyright>
 *
 * $Id: BasicAttributeImpl.java,v 1.14 2005/09/13 14:16:31 dtinker Exp $
 */
package org.eclipse.jsr220orm.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jsr220orm.metadata.AttributeMetaData;
import org.eclipse.jsr220orm.metadata.BasicAttribute;
import org.eclipse.jsr220orm.metadata.EmbeddedAttribute;
import org.eclipse.jsr220orm.metadata.EntityMetaData;
import org.eclipse.jsr220orm.metadata.MetadataPackage;
import org.eclipse.jsr220orm.metadata.OrmColumn;
import org.eclipse.jsr220orm.metadata.TypeMetaData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Basic Attribute</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.jsr220orm.metadata.impl.BasicAttributeImpl#getColumn <em>Column</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BasicAttributeImpl extends AttributeMetaDataImpl implements BasicAttribute {
	/**
	 * The cached value of the '{@link #getColumn() <em>Column</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColumn()
	 * @generated
	 * @ordered
	 */
	protected OrmColumn column = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BasicAttributeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return MetadataPackage.eINSTANCE.getBasicAttribute();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn getColumn() {
		if (column != null && column.eIsProxy()) {
			OrmColumn oldColumn = column;
			column = (OrmColumn)eResolveProxy((InternalEObject)column);
			if (column != oldColumn) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MetadataPackage.BASIC_ATTRIBUTE__COLUMN, oldColumn, column));
			}
		}
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrmColumn basicGetColumn() {
		return column;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setColumn(OrmColumn newColumn) {
		OrmColumn oldColumn = column;
		column = newColumn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MetadataPackage.BASIC_ATTRIBUTE__COLUMN, oldColumn, column));
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
					if (entityMetaData != null)
						msgs = ((InternalEObject)entityMetaData).eInverseRemove(this, MetadataPackage.ENTITY_META_DATA__ATTRIBUTE_LIST, EntityMetaData.class, msgs);
					return basicSetEntityMetaData((EntityMetaData)otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
					if (embeddedIn != null)
						msgs = ((InternalEObject)embeddedIn).eInverseRemove(this, MetadataPackage.EMBEDDED_ATTRIBUTE__ATTRIBUTE_LIST, EmbeddedAttribute.class, msgs);
					return basicSetEmbeddedIn((EmbeddedAttribute)otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
					if (mappedBy != null)
						msgs = ((InternalEObject)mappedBy).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__INVERSE_LIST, AttributeMetaData.class, msgs);
					return basicSetMappedBy((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicAdd(otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
					if (overrideOf != null)
						msgs = ((InternalEObject)overrideOf).eInverseRemove(this, MetadataPackage.ATTRIBUTE_META_DATA__OVERRIDE_LIST, AttributeMetaData.class, msgs);
					return basicSetOverrideOf((AttributeMetaData)otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
	 * @generated
	 */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
					return basicSetEntityMetaData(null, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
					return basicSetEmbeddedIn(null, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
					return basicSetMappedBy(null, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
					return ((InternalEList)getInverseList()).basicRemove(otherEnd, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
					return basicSetOverrideOf(null, msgs);
				case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
					return ((InternalEList)getOverrideList()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
				if (resolve) return getEntityMetaData();
				return basicGetEntityMetaData();
			case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
				if (resolve) return getEmbeddedIn();
				return basicGetEmbeddedIn();
			case MetadataPackage.BASIC_ATTRIBUTE__NAME:
				return getName();
			case MetadataPackage.BASIC_ATTRIBUTE__JAVA_TYPE:
				if (resolve) return getJavaType();
				return basicGetJavaType();
			case MetadataPackage.BASIC_ATTRIBUTE__FETCH_TYPE:
				return new Integer(getFetchType());
			case MetadataPackage.BASIC_ATTRIBUTE__OPTIONAL:
				return isOptional() ? Boolean.TRUE : Boolean.FALSE;
			case MetadataPackage.BASIC_ATTRIBUTE__GETTER_METHOD_NAME:
				return getGetterMethodName();
			case MetadataPackage.BASIC_ATTRIBUTE__SETTER_METHOD_NAME:
				return getSetterMethodName();
			case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
				if (resolve) return getMappedBy();
				return basicGetMappedBy();
			case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
				return getInverseList();
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
				if (resolve) return getOverrideOf();
				return basicGetOverrideOf();
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
				return getOverrideList();
			case MetadataPackage.BASIC_ATTRIBUTE__COLUMN:
				if (resolve) return getColumn();
				return basicGetColumn();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__NAME:
				setName((String)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__FETCH_TYPE:
				setFetchType(((Integer)newValue).intValue());
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OPTIONAL:
				setOptional(((Boolean)newValue).booleanValue());
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName((String)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName((String)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				getInverseList().addAll((Collection)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				getOverrideList().addAll((Collection)newValue);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__COLUMN:
				setColumn((OrmColumn)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
				setEntityMetaData((EntityMetaData)null);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
				setEmbeddedIn((EmbeddedAttribute)null);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__JAVA_TYPE:
				setJavaType((TypeMetaData)null);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__FETCH_TYPE:
				setFetchType(FETCH_TYPE_EDEFAULT);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OPTIONAL:
				setOptional(OPTIONAL_EDEFAULT);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__GETTER_METHOD_NAME:
				setGetterMethodName(GETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__SETTER_METHOD_NAME:
				setSetterMethodName(SETTER_METHOD_NAME_EDEFAULT);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
				setMappedBy((AttributeMetaData)null);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
				getInverseList().clear();
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
				setOverrideOf((AttributeMetaData)null);
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
				getOverrideList().clear();
				return;
			case MetadataPackage.BASIC_ATTRIBUTE__COLUMN:
				setColumn((OrmColumn)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case MetadataPackage.BASIC_ATTRIBUTE__ENTITY_META_DATA:
				return entityMetaData != null;
			case MetadataPackage.BASIC_ATTRIBUTE__EMBEDDED_IN:
				return embeddedIn != null;
			case MetadataPackage.BASIC_ATTRIBUTE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case MetadataPackage.BASIC_ATTRIBUTE__JAVA_TYPE:
				return javaType != null;
			case MetadataPackage.BASIC_ATTRIBUTE__FETCH_TYPE:
				return fetchType != FETCH_TYPE_EDEFAULT;
			case MetadataPackage.BASIC_ATTRIBUTE__OPTIONAL:
				return optional != OPTIONAL_EDEFAULT;
			case MetadataPackage.BASIC_ATTRIBUTE__GETTER_METHOD_NAME:
				return GETTER_METHOD_NAME_EDEFAULT == null ? getterMethodName != null : !GETTER_METHOD_NAME_EDEFAULT.equals(getterMethodName);
			case MetadataPackage.BASIC_ATTRIBUTE__SETTER_METHOD_NAME:
				return SETTER_METHOD_NAME_EDEFAULT == null ? setterMethodName != null : !SETTER_METHOD_NAME_EDEFAULT.equals(setterMethodName);
			case MetadataPackage.BASIC_ATTRIBUTE__MAPPED_BY:
				return mappedBy != null;
			case MetadataPackage.BASIC_ATTRIBUTE__INVERSE_LIST:
				return inverseList != null && !inverseList.isEmpty();
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_OF:
				return overrideOf != null;
			case MetadataPackage.BASIC_ATTRIBUTE__OVERRIDE_LIST:
				return overrideList != null && !overrideList.isEmpty();
			case MetadataPackage.BASIC_ATTRIBUTE__COLUMN:
				return column != null;
		}
		return eDynamicIsSet(eFeature);
	}

    public void getTopLevelSqlObjects(HashSet sqlObjects) {
    }

    public List getColumns() {
        ArrayList cols = new ArrayList(1);
        if (column != null) {
            cols.add(column);
        }
        return cols;
    }
    
	public void makeNonPersistent() {
		if (column != null) {
			column.delete();
			setColumn(null);
		}
		super.makeNonPersistent();
	}

} //BasicAttributeImpl
