/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.core.internal.product;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsr220orm.core.OrmPlugin;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class OrmProduct {
    private String id;
    private String name;
    private String version;
    private String vendor;
    private String entityModelManager;
    private String namespace;
    private Image icon;
    private Properties properties = new Properties();

    OrmProduct(String id, String name, String version, String vendor, String entityModelManager, String icon, String namespace) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.vendor = vendor;
        this.entityModelManager = entityModelManager;
        this.namespace = namespace;
        if (icon != null && icon.trim().length() > 0) {
            try {
                Bundle bundle = Platform.getBundle((String)namespace);
                URL resource = bundle.getEntry(icon);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    this.icon = new Image((Device)Display.getCurrent(), in);
                    in.close();
                } else {
                    OrmPlugin.log(null, null, (IStatus)new Status(2, "org.eclipse.jsr220orm.core", 0, "Could not create icon '" + icon + "' for " + name, null));
                }
            }
            catch (Exception x) {
                OrmPlugin.log(null, "Could not create icon '" + icon + "' for " + name, x, 2);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getEntityModelManager() {
        return this.entityModelManager;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        if (this.version == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " (" + this.version + ")";
    }

    public Image getIcon() {
        return this.icon;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

