/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jsr220orm.core.IEntityModelManager;
import org.eclipse.jsr220orm.core.internal.product.OrmProject;
import org.eclipse.jsr220orm.core.nature.OrmNature;
import org.eclipse.jsr220orm.core.options.IIntOption;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.views.MappingView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NewEntityComposite {
    private static final String ADD_CLASS = "addClass-";
    private static final String IMG = "img-";
    private FormText formText;
    private ICompilationUnit unit;
    private Form mainForm;
    private MappingView view;

    public NewEntityComposite(MappingView view) {
        this.view = view;
    }

    public Composite getComposite() {
        return this.mainForm;
    }

    public void setCompilationUnit(ICompilationUnit unit) throws JavaModelException {
        this.unit = unit;
        this.formText.setText(this.getText(unit), true, false);
    }

    public void createComposite(Composite parent, int style, FormToolkit toolkit) {
        this.mainForm = toolkit.createForm(parent);
        this.mainForm.setText("Class not Persistent");
        GridLayout gridLayout = new GridLayout();
        this.mainForm.getBody().setLayout((Layout)gridLayout);
        this.formText = toolkit.createFormText(this.mainForm.getBody(), true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.formText.setLayoutData((Object)gridData);
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.startsWith(NewEntityComposite.ADD_CLASS)) {
                    String intStr = href.substring(NewEntityComposite.ADD_CLASS.length());
                    NewEntityComposite.this.addClass(NewEntityComposite.this.unit, Integer.parseInt(intStr));
                }
            }
        });
    }

    private void addReachable(String string) {
        System.out.println("NewEntityComposite.addReachable(): " + string);
    }

    private void addClass(ICompilationUnit unit, int option) {
        IJavaProject javaProject = (IJavaProject)unit.getAncestor(2);
        IProject project = javaProject.getProject();
        String name = unit.findPrimaryType().getFullyQualifiedName();
        try {
            OrmProject activeOrmProject;
            OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
            if (nature != null && (activeOrmProject = nature.getActiveOrmProject()) != null) {
                IEntityModelManager modelManager = activeOrmProject.getModelManager();
                List mappings = modelManager.getPossibleEntityMappings(null);
                IIntOption intOption = null;
                for (IIntOption tempOption : mappings) {
                    if (tempOption.getId() != option) continue;
                    intOption = tempOption;
                    break;
                }
                modelManager.makePersistent((Collection)Collections.singleton(name), intOption);
            }
        }
        catch (CoreException e) {
            OrmUiPlugin.logException(e, "Could not add class " + name, this.formText.getShell());
        }
    }

    private String getText(ICompilationUnit unit) throws JavaModelException {
        IJavaProject javaProject = (IJavaProject)unit.getAncestor(2);
        IProject project = javaProject.getProject();
        String name = unit.findPrimaryType().getFullyQualifiedName();
        try {
            OrmProject activeOrmProject;
            OrmNature nature = (OrmNature)project.getNature("org.eclipse.jsr220orm.core.nature");
            if (nature != null && (activeOrmProject = nature.getActiveOrmProject()) != null) {
                List mappings = activeOrmProject.getModelManager().getPossibleEntityMappings(null);
                if (mappings.isEmpty()) {
                    return "No mapping for " + name;
                }
                StringBuffer buffer = new StringBuffer("<form>Make ");
                buffer.append(name);
                buffer.append(":\n\n");
                for (IIntOption option : mappings) {
                    buffer.append("<p><img href=\"");
                    buffer.append(IMG);
                    buffer.append(option.getId());
                    buffer.append("\"/> <a href=\"");
                    buffer.append(ADD_CLASS);
                    buffer.append(option.getId());
                    buffer.append("\">");
                    buffer.append(option.getText());
                    buffer.append("</a> ");
                    buffer.append(option.getTooltipText());
                    buffer.append("</p>\n");
                    Image image = ExtendedImageRegistry.INSTANCE.getImage(option.getImage());
                    if (image == null) continue;
                    this.formText.setImage(IMG + option.getId(), image);
                }
                buffer.append("</form>");
                return buffer.toString();
            }
        }
        catch (CoreException e) {
            OrmUiPlugin.logException(e, "Could not add class " + name, this.formText.getShell());
        }
        return "No mapping for " + name;
    }
}

