/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsr220orm.ui.OrmUiPlugin;
import org.eclipse.jsr220orm.ui.internal.views.MappingView;
import org.eclipse.jsr220orm.ui.internal.wizards.AddPersistenceWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AddPersistenceComposite {
    private static final String ADD_PERSISTENCE = "addPersistence-";
    private FormText formText;
    private Form mainForm;
    private IProject project;
    private MappingView view;

    public AddPersistenceComposite(MappingView view) {
        this.view = view;
    }

    public Composite getComposite() {
        return this.mainForm;
    }

    public void setIProject(IProject project) {
        this.project = project;
        this.formText.setText(this.getText(project), true, false);
    }

    public void createComposite(Composite parent, int style, FormToolkit toolkit) {
        this.mainForm = toolkit.createForm(parent);
        this.mainForm.setText("Project persistence disabled");
        GridLayout gridLayout = new GridLayout();
        this.mainForm.getBody().setLayout((Layout)gridLayout);
        this.formText = toolkit.createFormText(this.mainForm.getBody(), true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.formText.setLayoutData((Object)gridData);
        this.formText.setImage("addClass", OrmUiPlugin.getImageDescriptor("icons/memoryreset_tsk_002.gif").createImage());
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.startsWith(AddPersistenceComposite.ADD_PERSISTENCE)) {
                    AddPersistenceComposite.this.addPersistence(AddPersistenceComposite.this.project);
                }
            }
        });
    }

    private void addPersistence(IProject project) {
        AddPersistenceWizard wizard = new AddPersistenceWizard(project);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        this.view.doUpdate(true);
    }

    private String getText(IProject project) {
        StringBuffer buffer = new StringBuffer("<form>\n");
        String name = project.getName();
        buffer.append("<p><img href=\"addClass\"/><a href=\"");
        buffer.append(ADD_PERSISTENCE);
        buffer.append(name);
        buffer.append("\">Select a Persistence product </a> for project: ");
        buffer.append(name);
        buffer.append(".</p>\n");
        buffer.append("</form>");
        return buffer.toString();
    }
}

