/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsr220orm.ui.internal.binding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jsr220orm.ui.internal.binding.EmfAbstractBinding;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmfRadioButtonGroupBinding
extends EmfAbstractBinding
implements SelectionListener {
    protected Composite composite;
    private FormToolkit toolkit;
    protected int style = 16;
    private Color foreground;

    public EmfRadioButtonGroupBinding(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void bind(AdapterFactory adapterFactory, Widget widget, int featureId) {
        super.bind(adapterFactory, widget, featureId);
        this.composite = (Composite)widget;
    }

    protected void installListeners() {
        super.installListeners();
        Control[] children = this.composite.getChildren();
        int x = 0;
        while (x < children.length) {
            Button button = (Button)children[x];
            button.addSelectionListener((SelectionListener)this);
            ++x;
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        Control[] children = this.composite.getChildren();
        int x = 0;
        while (x < children.length) {
            Button button = (Button)children[x];
            button.removeSelectionListener((SelectionListener)this);
            ++x;
        }
    }

    protected void setChoicesFromModel(IItemLabelProvider labelProvider, Collection choices) {
        Button button;
        Control[] children = this.composite.getChildren();
        int x = children.length;
        while (x < choices.size()) {
            button = this.toolkit.createButton(this.composite, "", this.style);
            if (this.foreground != null) {
                button.setForeground(this.foreground);
            }
            ++x;
        }
        x = choices.size();
        while (x < children.length) {
            button = (Button)children[x];
            button.removeSelectionListener((SelectionListener)this);
            button.dispose();
            ++x;
        }
        children = this.composite.getChildren();
        ArrayList temp = new ArrayList(choices);
        int x2 = 0;
        while (x2 < children.length) {
            Button button2 = (Button)children[x2];
            Object choice = temp.get(x2);
            button2.removeSelectionListener((SelectionListener)this);
            button2.setData(choice);
            String text = labelProvider.getText(choice);
            button2.setText(text);
            Object image = labelProvider.getImage(choice);
            if (image instanceof Image) {
                button2.setImage((Image)image);
            } else {
                button2.setImage(null);
            }
            button2.addSelectionListener((SelectionListener)this);
            ++x2;
        }
        this.composite.redraw();
    }

    protected void setValueFromModel(IItemLabelProvider labelProvider, Object value) {
        Control[] children = this.composite.getChildren();
        int x = 0;
        while (x < children.length) {
            Button button = (Button)children[x];
            Object data = button.getData();
            button.setSelection(this.isValidOption(value, data));
            ++x;
        }
    }

    protected boolean isValidOption(Object value, Object option) {
        return value != null && value.equals(option);
    }

    public void widgetSelected(SelectionEvent e) {
        this.setValuesFromWidget(((Button)e.getSource()).getData());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

