/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.ui.tests.fetch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfilesReader;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfilesWriter;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.remote.ui.tests.fetch.AbstractRemoteImportProfilesIOTest;
import org.junit.Assert;
import org.junit.Test;

public class RemoteImportProfilesWriterTest
extends AbstractRemoteImportProfilesIOTest {
    private static final String ENCODING = "UTF-8";
    private static final String LINE_SEPARATOR_PROPERTY = "line.separator";

    @Test
    public void testValidateValid() throws Exception {
        String writtenXML = RemoteImportProfilesWriter.writeProfilesToXML((TracePackageElement[])RemoteImportProfilesWriterTest.generateElements());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(writtenXML.getBytes(ENCODING));
        RemoteImportProfilesReader.validate((InputStream)inputStream);
        File expectedFile = RemoteImportProfilesWriterTest.getProfilesFile((IPath)VALID_PROFILE_PATH);
        String expectedContent = new String(Files.readAllBytes(Paths.get(expectedFile.toURI())), ENCODING);
        String sysLineSeparator = System.getProperty(LINE_SEPARATOR_PROPERTY);
        writtenXML = writtenXML.replace(sysLineSeparator, "\n");
        Assert.assertEquals((Object)expectedContent, (Object)writtenXML);
    }

    private static TracePackageElement[] generateElements() {
        RemoteImportProfileElement profileElement = new RemoteImportProfileElement(null, "myProfile");
        RemoteImportConnectionNodeElement nodeElement = new RemoteImportConnectionNodeElement((TracePackageElement)profileElement, "myhost", "ssh://user@127.0.0.1:22");
        RemoteImportTraceGroupElement traceGroupElement = new RemoteImportTraceGroupElement((TracePackageElement)nodeElement, "/home/user/traces/test/test_with_lttng");
        traceGroupElement.setRecursive(true);
        TracePackageTraceElement traceElement = new TracePackageTraceElement((TracePackageElement)traceGroupElement, "test.log.(group1)", "org.eclipse.tracecompass.tmf.remote.ui.test.tracetype1");
        new TracePackageFilesElement((TracePackageElement)traceElement, ".*test\\.log\\.(\\d+)");
        traceElement = new TracePackageTraceElement((TracePackageElement)traceGroupElement, "TestLog.(group1)", "org.eclipse.tracecompass.tmf.remote.ui.test.tracetype2");
        new TracePackageFilesElement((TracePackageElement)traceElement, ".*TestLog\\.(\\d+)");
        traceGroupElement = new RemoteImportTraceGroupElement((TracePackageElement)nodeElement, "/home/user/traces/test/");
        traceGroupElement.setRecursive(false);
        traceElement = new TracePackageTraceElement((TracePackageElement)traceGroupElement, "lttng/(group1)", "org.eclipse.linuxtools.tmf.ui.type.ctf");
        new TracePackageFilesElement((TracePackageElement)traceElement, "lttng/(.*)");
        nodeElement = new RemoteImportConnectionNodeElement((TracePackageElement)profileElement, "myhost3", "ssh://user@127.0.0.1:22");
        traceGroupElement = new RemoteImportTraceGroupElement((TracePackageElement)nodeElement, "/home");
        traceGroupElement.setRecursive(false);
        traceElement = new TracePackageTraceElement((TracePackageElement)traceGroupElement, "", "trace.type");
        new TracePackageFilesElement((TracePackageElement)traceElement, ".*");
        RemoteImportProfileElement profileElement2 = new RemoteImportProfileElement(null, "myProfile2");
        RemoteImportConnectionNodeElement nodeElement2 = new RemoteImportConnectionNodeElement((TracePackageElement)profileElement2, "myhost2", "ssh://user@142.111.222.333:22");
        traceGroupElement = new RemoteImportTraceGroupElement((TracePackageElement)nodeElement2, "/home/user/traces/test/");
        traceGroupElement.setRecursive(false);
        traceElement = new TracePackageTraceElement((TracePackageElement)traceGroupElement, "lttng/(group1)", "org.eclipse.linuxtools.tmf.ui.type.ctf");
        new TracePackageFilesElement((TracePackageElement)traceElement, "lttng/(.*)");
        return new TracePackageElement[]{profileElement, profileElement2};
    }
}

