/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.gdbtrace.ui.views.project.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.gdbtrace.ui.views.project.dialogs.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SelectTraceExecutableDialog
extends SelectionStatusDialog {
    private final IStatus OK_STATUS = new Status(0, "org.eclipse.tracecompass.gdbtrace.ui", "");
    private final IStatus PATH_ERROR_STATUS = new Status(4, "org.eclipse.tracecompass.gdbtrace.ui", Messages.SelectTraceExecutableDialog_Message);
    private final IStatus BINARY_ERROR_STATUS = new Status(4, "org.eclipse.tracecompass.gdbtrace.ui", Messages.SelectTraceExecutableDialog_BinaryError);
    private Text fExecutableNameEntry;
    private IPath fExecutablePath;

    public SelectTraceExecutableDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(Messages.SelectTraceExecutableDialog_Title);
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.fExecutablePath));
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite);
        this.setStatusLineAboveButtons(true);
        this.updateStatus(this.PATH_ERROR_STATUS);
        return composite;
    }

    private void createFolderNameGroup(Composite parent) {
        final Shell shell = parent.getShell();
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setFont(font);
        label.setText(Messages.SelectTraceExecutableDialog_ExecutableName);
        this.fExecutableNameEntry = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fExecutableNameEntry.setLayoutData((Object)data);
        this.fExecutableNameEntry.setFont(font);
        this.fExecutableNameEntry.addListener(24, event -> {
            this.fExecutablePath = Path.fromOSString((String)this.fExecutableNameEntry.getText());
            if (!this.validateExecutableName()) {
                this.updateStatus(this.PATH_ERROR_STATUS);
            } else if (!this.validateExecutableBinary()) {
                this.updateStatus(this.BINARY_ERROR_STATUS);
            } else {
                this.updateStatus(this.OK_STATUS);
            }
        });
        Button browseExecutableButton = new Button(composite, 0);
        browseExecutableButton.setText(Messages.SelectTraceExecutableDialog_Browse);
        browseExecutableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = TmfFileDialogFactory.create((Shell)shell);
                String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                dlg.setFilterPath(workspacePath);
                dlg.setText(Messages.SelectTraceExecutableDialog_ExecutablePrompt);
                String path = dlg.open();
                if (path != null) {
                    SelectTraceExecutableDialog.this.fExecutableNameEntry.setText(path);
                }
            }
        });
    }

    private boolean validateExecutableName() {
        if (this.fExecutablePath != null) {
            File file = new File(this.fExecutablePath.toOSString());
            return file.exists() && file.isFile();
        }
        return false;
    }

    private boolean validateExecutableBinary() {
        try {
            IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
            IBinaryParser.IBinaryFile binary = parser.getBinary(this.fExecutablePath);
            if (binary instanceof IBinaryParser.IBinaryObject) {
                return true;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    public IPath getExecutablePath() {
        return this.fExecutablePath;
    }
}

