/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.IHelpResolver;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractCompletionProvider
implements ICompletionProvider {
    private Collection<ScriptCompletionProposal> fProposals = null;
    private ICompletionContext fContext;

    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getType() != ICompletionContext.Type.UNKNOWN;
    }

    @Override
    public Collection<? extends ScriptCompletionProposal> getProposals(ICompletionContext context) {
        this.fContext = context;
        this.fProposals = new ArrayList<ScriptCompletionProposal>();
        this.prepareProposals(context);
        Collection<ScriptCompletionProposal> result = this.fProposals;
        this.fProposals = null;
        this.fContext = null;
        return result;
    }

    public ICompletionContext getContext() {
        return this.fContext;
    }

    protected void addProposal(ScriptCompletionProposal proposal) {
        this.fProposals.add(proposal);
    }

    protected void addProposal(StyledString displayString, String replacementString, IImageResolver imageResolver, int priority, IHelpResolver helpResolver) {
        this.fProposals.add(new ScriptCompletionProposal(this.fContext, displayString, replacementString, imageResolver, priority, helpResolver));
    }

    protected void addProposal(String displayString, String replacementString, IImageResolver imageResolver, int priority, IHelpResolver helpResolver) {
        this.fProposals.add(new ScriptCompletionProposal(this.fContext, displayString, replacementString, imageResolver, priority, helpResolver));
    }

    protected boolean matchesFilter(String proposal) {
        return AbstractCompletionProvider.matches(this.fContext.getFilter(), proposal);
    }

    protected boolean matchesFilterIgnoreCase(String proposal) {
        return AbstractCompletionProvider.matchesIgnoreCase(this.fContext.getFilter(), proposal);
    }

    protected static boolean matches(String filter, String proposal) {
        return filter != null ? proposal.startsWith(filter) : true;
    }

    protected static boolean matchesIgnoreCase(String filter, String proposal) {
        return filter != null ? proposal.toLowerCase().startsWith(filter.toLowerCase()) : true;
    }

    protected abstract void prepareProposals(ICompletionContext var1);

    public static class DescriptorImageResolver
    implements IImageResolver {
        private final ImageDescriptor fDescriptor;

        public DescriptorImageResolver() {
            this.fDescriptor = null;
        }

        public DescriptorImageResolver(ImageDescriptor descriptor) {
            this.fDescriptor = descriptor;
        }

        @Override
        public Image getImage() {
            return this.getDescriptor() != null ? this.getDescriptor().createImage() : null;
        }

        protected ImageDescriptor getDescriptor() {
            return this.fDescriptor;
        }
    }
}

