/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.latency;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisEventBasedModule;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IGroupingSegmentAspect;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.SyscallLookup;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.SystemCall;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.segmentstore.core.SegmentStoreFactory;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SystemCallLatencyAnalysis
extends AbstractSegmentStoreAnalysisEventBasedModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.latency.syscall";
    private static final String RET_FIELD = "ret";
    private static final int VERSION = 2;
    private static final Collection<ISegmentAspect> BASE_ASPECTS = ImmutableList.of((Object)SyscallNameAspect.INSTANCE, (Object)SyscallTidAspect.INSTANCE, (Object)SyscallRetAspect.INSTANCE, (Object)SyscallComponentAspect.INSTANCE, (Object)SyscallFileAspect.INSTANCE);

    public String getId() {
        return ID;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException();
        }
        IAnalysisModule module = trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        if (module == null) {
            return Collections.emptySet();
        }
        return ImmutableSet.of((Object)module);
    }

    public Iterable<ISegmentAspect> getSegmentAspects() {
        return BASE_ASPECTS;
    }

    protected int getVersion() {
        return 2;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SegmentStoreFactory.SegmentStoreType getSegmentStoreType() {
        return SegmentStoreFactory.SegmentStoreType.OnDisk;
    }

    protected AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest createAnalysisRequest(ISegmentStore<ISegment> syscalls, IProgressMonitor monitor) {
        return new SyscallLatencyAnalysisRequest(syscalls, monitor);
    }

    protected @NonNull IHTIntervalReader<ISegment> getSegmentReader() {
        return SystemCall.READER;
    }

    public static final class SyscallCallsiteAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallCallsiteAspect();

        private SyscallCallsiteAspect() {
        }

        public String getName() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_sourceLookupName);
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_sourceLookupDescription);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable Object resolve(ISegment segment) {
            String file = (String)SyscallFileAspect.INSTANCE.resolve(segment);
            if (file == null || file.isEmpty()) {
                return null;
            }
            return new TmfCallsite(file, Long.valueOf(0L));
        }
    }

    private static final class SyscallComponentAspect
    implements IGroupingSegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallComponentAspect();

        private SyscallComponentAspect() {
        }

        public String getName() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_componentName);
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_componentDescription);
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SystemCall && segment2 instanceof SystemCall) {
                    int res = SyscallLookup.getInstance().getComponent(((SystemCall)segment1).getName()).compareTo(SyscallLookup.getInstance().getComponent(((SystemCall)segment2).getName()));
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return SyscallLookup.getInstance().getComponent(((SystemCall)segment).getName());
            }
            return "";
        }
    }

    private static final class SyscallFileAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallFileAspect();

        private SyscallFileAspect() {
        }

        public String getName() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_fileName);
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SystemCallLatencyAnalysis_fileDescription);
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SystemCall && segment2 instanceof SystemCall) {
                    int res = SyscallLookup.getInstance().getFile(((SystemCall)segment1).getName()).compareTo(SyscallLookup.getInstance().getFile(((SystemCall)segment2).getName()));
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return SyscallLookup.getInstance().getFile(((SystemCall)segment).getName());
            }
            return "";
        }
    }

    private class SyscallLatencyAnalysisRequest
    extends AbstractSegmentStoreAnalysisEventBasedModule.AbstractSegmentStoreAnalysisRequest {
        private final Map<Integer, SystemCall.InitialInfo> fOngoingSystemCalls;
        private @Nullable IKernelAnalysisEventLayout fLayout;
        private final IProgressMonitor fMonitor;

        public SyscallLatencyAnalysisRequest(ISegmentStore<ISegment> syscalls, IProgressMonitor monitor) {
            super((AbstractSegmentStoreAnalysisEventBasedModule)SystemCallLatencyAnalysis.this, syscalls);
            this.fOngoingSystemCalls = new HashMap<Integer, SystemCall.InitialInfo>();
            this.fMonitor = monitor;
        }

        public void handleData(ITmfEvent event) {
            String eventName;
            super.handleData(event);
            IKernelAnalysisEventLayout layout = this.fLayout;
            if (layout == null) {
                IKernelTrace trace = (IKernelTrace)event.getTrace();
                this.fLayout = layout = trace.getKernelEventLayout();
            }
            if ((eventName = event.getName()).startsWith(layout.eventSyscallEntryPrefix()) || eventName.startsWith(layout.eventCompatSyscallEntryPrefix())) {
                Integer tid;
                try {
                    tid = KernelTidAspect.INSTANCE.resolve(event, true, this.fMonitor);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (tid == null) {
                    return;
                }
                long startTime = event.getTimestamp().toNanos();
                String syscallName = eventName.substring(layout.eventSyscallEntryPrefix().length());
                SystemCall.InitialInfo newSysCall = new SystemCall.InitialInfo(startTime, syscallName.intern(), tid);
                this.fOngoingSystemCalls.put(tid, newSysCall);
            } else if (eventName.startsWith(layout.eventSyscallExitPrefix())) {
                Integer tid;
                try {
                    tid = KernelTidAspect.INSTANCE.resolve(event, true, this.fMonitor);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (tid == null) {
                    return;
                }
                SystemCall.InitialInfo info = this.fOngoingSystemCalls.remove(tid);
                if (info == null) {
                    return;
                }
                long endTime = event.getTimestamp().toNanos();
                Integer ret = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{SystemCallLatencyAnalysis.RET_FIELD});
                SystemCall syscall = new SystemCall(info, endTime, ret == null ? -1 : ret);
                this.getSegmentStore().add((Object)syscall);
            }
        }

        public void handleCompleted() {
            this.fOngoingSystemCalls.clear();
            super.handleCompleted();
        }

        public void handleCancel() {
            this.fMonitor.setCanceled(true);
            super.handleCancel();
        }
    }

    private static final class SyscallNameAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallNameAspect();

        private SyscallNameAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SystemCall);
        }

        public String getName() {
            return Messages.getMessage(Messages.SegmentAspectName_SystemCall);
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SystemCall && segment2 instanceof SystemCall) {
                    int res = ((SystemCall)segment1).getName().compareTo(((SystemCall)segment2).getName());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return ((SystemCall)segment).getName();
            }
            return "";
        }
    }

    private static final class SyscallRetAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallRetAspect();

        private SyscallRetAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SystemCallRet);
        }

        public String getName() {
            return Messages.getMessage(Messages.SegmentAspectName_SystemCallRet);
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return ((SystemCall)segment).getReturnValue();
            }
            return "";
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SystemCall && segment2 instanceof SystemCall) {
                    int res = Integer.compare(((SystemCall)segment1).getReturnValue(), ((SystemCall)segment2).getReturnValue());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }
    }

    private static final class SyscallTidAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SyscallTidAspect();

        private SyscallTidAspect() {
        }

        public String getHelpText() {
            return Messages.getMessage(Messages.SegmentAspectHelpText_SystemCallTid);
        }

        public String getName() {
            return OsStrings.tid();
        }

        public @Nullable Comparator<?> getComparator() {
            return (segment1, segment2) -> {
                if (segment1 == null) {
                    return 1;
                }
                if (segment2 == null) {
                    return -1;
                }
                if (segment1 instanceof SystemCall && segment2 instanceof SystemCall) {
                    int res = Integer.compare(((SystemCall)segment1).getTid(), ((SystemCall)segment2).getTid());
                    return res != 0 ? res : SegmentComparators.INTERVAL_START_COMPARATOR.thenComparing(SegmentComparators.INTERVAL_END_COMPARATOR).compare((ISegment)segment1, (ISegment)segment2);
                }
                return 1;
            };
        }

        public @Nullable Integer resolve(ISegment segment) {
            if (segment instanceof SystemCall) {
                return ((SystemCall)segment).getTid();
            }
            return -1;
        }
    }
}

