/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.Statistics;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;

public class AggregatedCalledFunctionStatistics {
    private final IStatistics<ICalledFunction> fDurations = new Statistics(f -> f.getLength());
    private final IStatistics<ICalledFunction> fSelfTimes = new Statistics(f -> f.getSelfTime());
    private final IStatistics<ICalledFunction> fCpuTimes = new Statistics(f -> f.getCpuTime());
    private final IStatistics<ICalledFunction> fNbCalls = new Statistics(f -> f.getCpuTime());

    public void update(ICalledFunction function) {
        this.fDurations.update((Object)function);
        this.fSelfTimes.update((Object)function);
        this.fCpuTimes.update((Object)function);
        this.fNbCalls.update((Object)function);
    }

    public void merge(AggregatedCalledFunctionStatistics statisticsNode) {
        this.fDurations.merge(statisticsNode.fDurations);
        this.fSelfTimes.merge(statisticsNode.fSelfTimes);
        this.fCpuTimes.merge(statisticsNode.fCpuTimes);
    }

    public void merge(AggregatedCalledFunctionStatistics other, boolean isGroup) {
        this.fDurations.merge(other.fDurations);
        this.fSelfTimes.merge(other.fSelfTimes);
        this.fCpuTimes.merge(other.fCpuTimes);
    }

    public IStatistics<ICalledFunction> getDurationStatistics() {
        return this.fDurations;
    }

    public IStatistics<ICalledFunction> getSelfTimeStatistics() {
        return this.fSelfTimes;
    }

    public IStatistics<ICalledFunction> getCpuTimesStatistics() {
        return this.fCpuTimes;
    }

    public String toString() {
        return "Aggregated function statistics: Durations: " + this.fDurations + ", Self times " + this.fSelfTimes;
    }
}

