/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.hrm.HardwareArbiter;
import org.polarsys.time4sys.marte.hrm.HardwareBus;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class BusBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private HardwareBus bus;
    private DesignBuilder designBuilder;

    public BusBuilder(DesignBuilder designBuilder, HardwareBus bus) {
        this.bus = bus;
        this.designBuilder = designBuilder;
    }

    public BusBuilder called(String name) {
        this.bus.setName(name);
        return this;
    }

    public BusBuilder thatEmits(TaskBuilder ... tasks) {
        TaskBuilder[] taskBuilderArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            TaskBuilder tb = taskBuilderArray[n2];
            this.bus.getOwnedResource().add((Object)tb.build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public BusBuilder thatEmits(StepBuilder ... steps) {
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            this.bus.getOwnedResource().add((Object)step.getTask().build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public BusBuilder under(HardwareArbiter arbiter) {
        this.bus.getArbiters().add((Object)arbiter);
        return this;
    }
}

