/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.grm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtectProtocolKind implements Enumerator
{
    FIFO(0, "FIFO", "FIFO"),
    NO_PREEMPTION(1, "NoPreemption", "NoPreemption"),
    PRIORITY_CEILING(2, "PriorityCeiling", "PriorityCeiling"),
    PRIORITY_INHERITANCE(3, "PriorityInheritance", "PriorityInheritance"),
    STACK_BASED(4, "StackBased", "StackBased"),
    UNDEF(5, "Undef", "Undef"),
    OTHER(6, "Other", "Other");

    public static final int FIFO_VALUE = 0;
    public static final int NO_PREEMPTION_VALUE = 1;
    public static final int PRIORITY_CEILING_VALUE = 2;
    public static final int PRIORITY_INHERITANCE_VALUE = 3;
    public static final int STACK_BASED_VALUE = 4;
    public static final int UNDEF_VALUE = 5;
    public static final int OTHER_VALUE = 6;
    private static final ProtectProtocolKind[] VALUES_ARRAY;
    public static final List<ProtectProtocolKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProtectProtocolKind[]{FIFO, NO_PREEMPTION, PRIORITY_CEILING, PRIORITY_INHERITANCE, STACK_BASED, UNDEF, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProtectProtocolKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtectProtocolKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtectProtocolKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtectProtocolKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtectProtocolKind get(int value) {
        switch (value) {
            case 0: {
                return FIFO;
            }
            case 1: {
                return NO_PREEMPTION;
            }
            case 2: {
                return PRIORITY_CEILING;
            }
            case 3: {
                return PRIORITY_INHERITANCE;
            }
            case 4: {
                return STACK_BASED;
            }
            case 5: {
                return UNDEF;
            }
            case 6: {
                return OTHER;
            }
        }
        return null;
    }

    private ProtectProtocolKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

