/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.trace.html.popup.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.trace.Event;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.Slice;

public class ExportAsHtml
implements IObjectActionDelegate {
    protected Shell shell;
    protected Slice slice = null;
    private File output;
    private FileOutputStream os;
    private OutputStreamWriter w;

    public static void export(Slice slice, File output) throws IOException {
        new ExportAsHtml().run(slice, output);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.slice == null) {
            System.out.println("Slice was null");
            return;
        }
        this.output = new File("slice.html");
        try {
            this.os = new FileOutputStream(this.output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        this.w = new OutputStreamWriter(this.os);
        try {
            this.export();
            this.w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (MessageDialog.openQuestion((Shell)this.shell, (String)"Trace Html exporter", (String)("Slice " + this.slice.getName() + " exported in " + this.output.getAbsolutePath() + ".\n" + "Would you view it?")) && this.output.exists() && this.output.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(this.output.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {}
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.slice = null;
        if (selection.isEmpty()) {
            return;
        }
        Object obj = null;
        if (selection instanceof IStructuredSelection) {
            obj = ((IStructuredSelection)selection).getFirstElement();
        }
        if (obj instanceof Slice) {
            this.slice = (Slice)obj;
        }
    }

    public void run(Slice slc, File output) throws IOException {
        assert (output != null);
        this.output = output;
        this.run(slc, new FileOutputStream(output));
    }

    public void run(Slice slc, FileOutputStream fileOutputStream) throws IOException {
        assert (fileOutputStream != null);
        this.os = fileOutputStream;
        this.run(slc, new OutputStreamWriter(this.os));
        this.w.close();
    }

    public void run(Slice slc, OutputStreamWriter outputStreamWriter) throws IOException {
        assert (outputStreamWriter != null);
        assert (slc != null);
        this.slice = slc;
        this.w = outputStreamWriter;
        this.export();
        this.w.flush();
    }

    protected void export() throws IOException {
        this.w.write("<!DOCTYPE html>");
        this.w.write("<html>");
        this.w.write("<head>");
        this.w.write("<meta charset='utf-8' />");
        this.w.write("<title>Tasks activation</title>");
        this.w.write("<link rel='stylesheet' href='http://www.designcps.com/cpal-editor/tasks.css' />");
        this.w.write("<link rel='stylesheet' href='tasks.css' />");
        this.w.write("</head>");
        this.w.write("<body>");
        this.w.write("<textarea id='cpal_tasks_tsv'>PID\tstart\tend\tname\tstate\n");
        this.exportEventsOf(this.slice.getName(), (List<Event>)this.slice.getEvents(), "activation");
        for (Slice sub : this.slice.getSubSlices()) {
            this.exportEventsOf(sub.getName(), sub, "activation");
        }
        for (Slice sub : this.slice.getOwnedSubSlices()) {
            this.exportEventsOf(sub.getName(), sub, "activation");
        }
        this.w.write("\n</textarea>");
        this.w.write("<section id='tasks'>");
        this.w.write("</section>");
        this.w.write("</body>");
        this.w.write("<script src='http://d3js.org/d3.v3.min.js' charset='utf-8'></script>");
        this.w.write("<script src='d3.min.js' charset='utf-8'></script>");
        this.w.write("<script src='http://www.designcps.com/cpal-editor/tasks.js'></script>");
        this.w.write("<script src='tasks.js'></script>");
        this.w.write("<script>window.updateSVG('cpal_tasks_tsv', []);</script>");
        this.w.write("</html>");
    }

    private void exportEventsOf(String label, Slice sub, String stateLabel) throws IOException {
        this.exportEventsOf(label, (List<Event>)sub.getEvents(), stateLabel);
        for (Slice subsub : sub.getSubSlices()) {
            this.exportEventsOf(label, subsub, subsub.getName());
        }
        for (Slice subsub : sub.getOwnedSubSlices()) {
            this.exportEventsOf(label, subsub, subsub.getName());
        }
    }

    protected void exportEventsOf(String label, List<Event> events, String stateLabel) throws IOException {
        Duration picosecond = NfpFactory.eINSTANCE.createDurationFromString("1ps");
        Duration start = null;
        Duration end = null;
        block4: for (Event evt : events) {
            if (!(evt instanceof SchedulingEvent)) continue;
            SchedulingEvent schedEvt = (SchedulingEvent)evt;
            switch (schedEvt.getKind()) {
                case RUNNING: {
                    start = schedEvt.getTimestamp();
                    break;
                }
                case SUSPENDED: 
                case BLOCKED: 
                case TERMINATED: {
                    if (start == null) continue block4;
                    end = schedEvt.getTimestamp();
                    assert (end != null);
                    this.w.write(Integer.toString(label.hashCode()));
                    this.w.write("\t");
                    this.w.write(Long.toString(start.divide(picosecond)));
                    this.w.write("\t");
                    this.w.write(Long.toString(end.divide(picosecond)));
                    this.w.write("\t");
                    this.w.write(label);
                    this.w.write("\t" + stateLabel + "\n");
                }
            }
        }
    }
}

