/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.editor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.polarsys.time4sys.editor.internal.RenameModelElementAction;
import org.polarsys.time4sys.marte.nfp.coreelements.NamedElement;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.presentation.Time4sysEditorPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Time4SysCommonActionProvider
extends CommonActionProvider {
    private Collection<IAction> createChildActions;
    private Map<String, Collection<IAction>> createChildSubmenuActions;
    private ICommonViewerWorkbenchSite viewSite;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.viewSite = (ICommonViewerWorkbenchSite)aSite.getViewSite();
    }

    public void fillContextMenu(IMenuManager menuManager) {
        EObject eObject;
        TransactionalEditingDomain domain;
        Object object;
        MenuManager createChildMenuManager = new MenuManager(Time4sysEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)createChildMenuManager);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject && (domain = TransactionUtil.getEditingDomain((EObject)(eObject = (EObject)object))) != null && EcoreUtil.getRootContainer((EObject)eObject) instanceof Project) {
            Collection newChildDescriptors = domain.getNewChildDescriptors(object, null);
            if (newChildDescriptors != null) {
                if (createChildMenuManager != null) {
                    this.depopulateManager((IContributionManager)createChildMenuManager, this.createChildSubmenuActions);
                    this.depopulateManager((IContributionManager)createChildMenuManager, this.createChildActions);
                }
                this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
                this.createChildSubmenuActions = this.extractSubmenuActions(this.createChildActions);
                if (createChildMenuManager != null) {
                    this.populateManager((IContributionManager)createChildMenuManager, this.createChildSubmenuActions, null);
                    this.populateManager((IContributionManager)createChildMenuManager, this.createChildActions, null);
                    createChildMenuManager.update(true);
                }
            }
            if (this.isRenamableModelElement(eObject)) {
                menuManager.add((IAction)new RenameModelElementAction((EditingDomain)domain, eObject));
            }
        }
    }

    private boolean isRenamableModelElement(EObject selection) {
        boolean isRenamableModelElement = selection instanceof NamedElement;
        return isRenamableModelElement;
    }

    private void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    private Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions) {
        LinkedHashMap<String, Collection<IAction>> createSubmenuActions = new LinkedHashMap<String, Collection<IAction>>();
        if (createActions != null) {
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                IAction action = actions.next();
                StringTokenizer st = new StringTokenizer(action.getText(), "|");
                if (st.countTokens() != 2) continue;
                String text = st.nextToken().trim();
                ArrayList<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(text);
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(text, submenuActions);
                }
                action.setText(st.nextToken().trim());
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    private void populateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions, String contributionID) {
        if (submenuActions != null) {
            for (Map.Entry<String, Collection<IAction>> entry : submenuActions.entrySet()) {
                MenuManager submenuManager = new MenuManager(entry.getKey());
                if (contributionID != null) {
                    manager.insertBefore(contributionID, (IContributionItem)submenuManager);
                } else {
                    manager.add((IContributionItem)submenuManager);
                }
                this.populateManager((IContributionManager)submenuManager, entry.getValue(), null);
            }
        }
    }

    private void depopulateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions) {
        if (submenuActions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                MenuManager submenuManager;
                IContributionItem contributionItem = items[i];
                if (contributionItem instanceof MenuManager && submenuActions.containsKey((submenuManager = (MenuManager)contributionItem).getMenuText())) {
                    this.depopulateManager((IContributionManager)submenuManager, submenuActions.get(contributionItem));
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    private void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    private Collection<IAction> generateCreateChildActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.viewSite.getPart(), selection, descriptor));
            }
        }
        return actions;
    }

    private Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        List createChildActions = (List)this.generateCreateChildActionsGen(descriptors, selection);
        Collections.sort(createChildActions, new Comparator<IAction>(){

            @Override
            public int compare(IAction a1, IAction a2) {
                return CommonPlugin.INSTANCE.getComparator().compare(a1.getText(), a2.getText());
            }
        });
        return createChildActions;
    }
}

