/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.EndToEndFlowConstraintBuilder;
import org.polarsys.time4sys.builder.design.ReferenceBuilder;
import org.polarsys.time4sys.builder.design.SchedulableResourceBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.grm.EDFParameters;
import org.polarsys.time4sys.marte.grm.FixedPriorityParameters;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.SchedulingParameter;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class TaskBuilder
implements SchedulableResourceBuilder<SoftwareSchedulableResource, TaskBuilder> {
    public static final String EDF_POLICY_NAME = "EDF";
    public static final String FP_POLICY_NAME = "FixedPriority";
    private static final EClass FP_PARAM_ECLASS = GrmPackage.eINSTANCE.getFixedPriorityParameters();
    private static final EClass EDF_PARAM_ECLASS = GrmPackage.eINSTANCE.getEDFParameters();
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private String period;
    protected SoftwareSchedulableResource task;
    private StepBuilder firstStep;
    private List<StepBuilder> ownedSteps = new LinkedList<StepBuilder>();
    private DesignBuilder design;
    private String wcet;
    private String bcet;
    private String jitter;
    private int nbEvents = 1;
    private String windowSize;
    private String deadline;
    protected EClass fpParamEClass;
    private boolean isSporadic = false;
    private String minInterarrival;
    private String maxInterarrival;
    private boolean isActivatedOnce = false;
    private ReferenceBuilder ref;
    private String offset;
    private ReferenceBuilder reference;

    public static TaskBuilder aTask() {
        return new TaskBuilder();
    }

    public TaskBuilder() {
        this(FP_PARAM_ECLASS);
    }

    public TaskBuilder(EClass pssParamEclass) {
        this(null, srmFactory.createSoftwareSchedulableResource(), pssParamEclass);
    }

    public TaskBuilder(DesignBuilder designBuilder, SoftwareSchedulableResource raw) {
        this(designBuilder, raw, FP_PARAM_ECLASS);
    }

    public TaskBuilder(DesignBuilder designBuilder, SoftwareSchedulableResource raw, EClass fpParamEClass) {
        this.task = raw == null ? srmFactory.createSoftwareSchedulableResource() : raw;
        assert (this.task != null);
        if (designBuilder == null) {
            SoftwareSchedulableResource container = this.task;
            while ((container = container.eContainer()) != null && !(container instanceof DesignModel)) {
            }
            if (container != null && container instanceof DesignModel) {
                this.design = new DesignBuilder((DesignModel)container);
            }
        } else {
            this.design = designBuilder;
        }
        this.fpParamEClass = fpParamEClass;
    }

    @Override
    public SoftwareSchedulableResource build(DesignBuilder design) {
        this.design = design;
        if (this.period != null) {
            this.firstStep().isPeriodic(this.period);
        }
        if (this.offset != null) {
            this.firstStep().ofOffset(this.offset);
        }
        if (this.reference != null) {
            this.firstStep().ofReference(this.reference);
        }
        if (this.windowSize != null) {
            this.firstStep().withSlidingWindow(this.nbEvents, this.windowSize).withReference(this.ref);
        }
        if (this.isSporadic) {
            this.firstStep().isSporadic(this.minInterarrival, this.maxInterarrival).withReference(this.ref);
        }
        if (this.isActivatedOnce) {
            this.firstStep().isActivatedOnce().withReference(this.ref);
        }
        if (this.jitter != null) {
            this.firstStep().hasJitter(this.jitter);
        }
        if (this.bcet != null) {
            this.firstStep().ofBCET(this.bcet);
        }
        if (this.wcet != null) {
            this.firstStep().ofWCET(this.wcet);
        }
        for (StepBuilder st : this.ownedSteps) {
            st.build();
        }
        if (this.deadline != null) {
            design.has(EndToEndFlowConstraintBuilder.anEndToEndConstraint().from(this.firstStep()).to(this).withDeadline(this.deadline));
            this.deadline = null;
        }
        return this.build();
    }

    public SoftwareSchedulableResource build() {
        if (this.design == null) {
            throw new IllegalStateException("Build() cannot be called until it has been built with a DesignBuilder once.");
        }
        return this.task;
    }

    public TaskBuilder ofPeriod(String value) {
        this.period = value;
        return this;
    }

    public Duration getPeriod() {
        if (this.design != null) {
            this.build();
            return this.firstStep().getPeriod();
        }
        return null;
    }

    public TaskBuilder ofOffset(String value) {
        this.offset = value;
        return this;
    }

    public Duration getOffset() {
        if (this.design != null) {
            this.build();
            return this.firstStep().getOffset();
        }
        return null;
    }

    public TaskBuilder withSlidingWindow(int nbEvents, String windowSize) {
        this.nbEvents = nbEvents;
        this.windowSize = windowSize;
        this.period = null;
        return this;
    }

    public TaskBuilder called(String value) {
        this.task.setName(value);
        return this;
    }

    public StepBuilder firstStep() {
        if (this.firstStep != null) {
            return this.firstStep;
        }
        if (this.design == null) {
            throw new IllegalStateException("Illegal API order of calls.");
        }
        for (Step step : this.design.allSteps()) {
            if (step.getConcurRes() != this.task) continue;
            if (step.getInputRel() != null) {
                while (!step.getInputRel().getPredec().isEmpty()) {
                    for (Step prec : step.getInputRel().getPredec()) {
                        if (prec.getConcurRes() != this.task) continue;
                        step = prec;
                    }
                }
            }
            return new StepBuilder(this.design, this, step);
        }
        this.firstStep = new StepBuilder(this.design, this);
        this.firstStep().called(this.task.getName());
        this.firstStep().build();
        return this.firstStep;
    }

    public StepBuilder anotherStep() {
        StepBuilder res = this.design.aStep();
        res.setTask(this);
        return res;
    }

    public TaskBuilder ofWCET(String value) {
        this.wcet = value;
        return this;
    }

    public TaskBuilder ofBCET(String value) {
        this.bcet = value;
        return this;
    }

    public StepBuilder whoseFirstStep() {
        return this.firstStep();
    }

    public TaskBuilder ofDeadline(String value) {
        Duration val = NfpFactory.eINSTANCE.createDurationFromString(value);
        this.setDeadline(val);
        this.deadline = value;
        return this;
    }

    public void setDeadline(Duration value) {
        EDFParameters edfParam = (EDFParameters)this.getSchedParams(EDF_POLICY_NAME, EDF_PARAM_ECLASS);
        edfParam.setDeadline(value);
    }

    public EDFParameters getEDFSchedParams(boolean buildIfNone) {
        return (EDFParameters)this.getSchedParams(EDF_POLICY_NAME, (EClass)(buildIfNone ? EDF_PARAM_ECLASS : null));
    }

    public FixedPriorityParameters getFPSchedParams(boolean buildIfNone) {
        return (FixedPriorityParameters)this.getSchedParams(FP_POLICY_NAME, buildIfNone ? this.fpParamEClass : null);
    }

    public Duration getDeadline() {
        EDFParameters edfParam = (EDFParameters)this.getSchedParams(EDF_POLICY_NAME, null);
        if (edfParam == null) {
            if (this.firstStep != null) {
                return this.firstStep.getPeriod();
            }
            return null;
        }
        return edfParam.getDeadline();
    }

    public TaskBuilder ofPriority(int value) {
        FixedPriorityParameters schedParam = (FixedPriorityParameters)this.getSchedParams(FP_POLICY_NAME, this.fpParamEClass);
        schedParam.setPriority(value);
        return this;
    }

    public int getPriority() {
        FixedPriorityParameters fp = (FixedPriorityParameters)this.getSchedParams(FP_POLICY_NAME, this.fpParamEClass);
        return fp.getPriority();
    }

    protected SchedulingParameter getSchedParams(String key, EClass eClass) {
        for (SchedulingParameter v : this.task.getSchedParams()) {
            if (!key.equals(v.getName())) continue;
            return v;
        }
        if (eClass == null) {
            return null;
        }
        SchedulingParameter sp = (SchedulingParameter)grmFactory.create(eClass);
        sp.setName(key);
        this.task.getSchedParams().add((Object)sp);
        return sp;
    }

    public TaskBuilder has(StepBuilder ... steps) {
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            step.setTask(this);
            this.ownedSteps.add(step);
            ++n2;
        }
        return this;
    }

    public TaskBuilder running(StepBuilder aStep) {
        return this.has(aStep);
    }

    public TaskBuilder ofET(String value) {
        return this.ofBCET(value).ofWCET(value);
    }

    public TaskBuilder ofJitter(String value) {
        this.jitter = value;
        return this;
    }

    public TaskBuilder runsInSequence(StepBuilder ... steps) {
        this.has(steps);
        StepBuilder prev = null;
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            if (prev != null) {
                prev.activates(step);
            }
            prev = step;
            ++n2;
        }
        return this;
    }

    public TaskBuilder thatRunsInSequence(StepBuilder ... steps) {
        return this.runsInSequence(steps);
    }

    public String getName() {
        return this.task.getName();
    }

    public void addOwnedResource(Resource value) {
        EList ownedResources = this.task.getOwnedResource();
        if (!ownedResources.contains((Object)value)) {
            ownedResources.add((Object)value);
        }
    }

    public void addOwnedResource(TaskBuilder value) {
        this.task.getOwnedResource().add((Object)value.task);
    }

    public Collection<Resource> getOwnedResource() {
        return this.task.getOwnedResource();
    }

    public EAnnotation annotate(String source) {
        return Annotations.annotate((EModelElement)this.task, source);
    }

    public boolean hasAnnotation(String source) {
        return Annotations.hasAnnotation((EModelElement)this.task, source);
    }

    public void unsetAnnotationAttr(String source, String attrname) {
        Annotations.unsetAnnotationAttr((EModelElement)this.task, source, attrname);
    }

    public TaskBuilder aperiodic() {
        return this.sporadic(null, null);
    }

    private TaskBuilder sporadic(String min, String max) {
        this.isSporadic = true;
        this.minInterarrival = min;
        this.maxInterarrival = max;
        return this;
    }

    public TaskBuilder withSingleActivation() {
        this.isActivatedOnce = true;
        return this;
    }

    public void withReference(ReferenceBuilder reference) {
        this.ref = reference;
        if (this.design != null && this.firstStep != null) {
            this.firstStep().withReference(this.ref);
        }
    }

    public ReferenceBuilder getReference() {
        return this.firstStep().getReference();
    }

    public DesignBuilder design() {
        return this.design;
    }

    public TaskBuilder ofReference(ReferenceBuilder value) {
        this.reference = value;
        return this;
    }
}

