/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.mapping.impl;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.MappableArtefact;
import org.polarsys.time4sys.mapping.MappingPackage;

public class LinkImpl
extends MinimalEObjectImpl.Container
implements Link {
    protected EList<Link> subLinks;
    protected Context rationale;
    protected EList<MappableArtefact> sources;
    protected EList<MappableArtefact> targets;

    protected LinkImpl() {
    }

    protected EClass eStaticClass() {
        return MappingPackage.Literals.LINK;
    }

    @Override
    public EList<Link> getSubLinks() {
        if (this.subLinks == null) {
            this.subLinks = new EObjectContainmentEList(Link.class, (InternalEObject)this, 0);
        }
        return this.subLinks;
    }

    @Override
    public Context getRationale() {
        if (this.rationale != null && this.rationale.eIsProxy()) {
            InternalEObject oldRationale = (InternalEObject)this.rationale;
            this.rationale = (Context)this.eResolveProxy(oldRationale);
            if (this.rationale != oldRationale && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldRationale, (Object)this.rationale));
            }
        }
        return this.rationale;
    }

    public Context basicGetRationale() {
        return this.rationale;
    }

    @Override
    public void setRationale(Context newRationale) {
        Context oldRationale = this.rationale;
        this.rationale = newRationale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldRationale, (Object)this.rationale));
        }
    }

    @Override
    public EList<MappableArtefact> getSources() {
        if (this.sources == null) {
            this.sources = new EObjectContainmentEList(MappableArtefact.class, (InternalEObject)this, 2);
        }
        return this.sources;
    }

    @Override
    public EList<MappableArtefact> getTargets() {
        if (this.targets == null) {
            this.targets = new EObjectContainmentEList(MappableArtefact.class, (InternalEObject)this, 3);
        }
        return this.targets;
    }

    @Override
    public EObject getUniqueSourceValue(String role) {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        for (MappableArtefact artefact : this.getSources()) {
            if (!role.equals(artefact.getName())) continue;
            return artefact.getValue();
        }
        return null;
    }

    @Override
    public EObject getUniqueTargetValue(String role) {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        for (MappableArtefact artefact : this.getTargets()) {
            if (!role.equals(artefact.getName())) continue;
            return artefact.getValue();
        }
        return null;
    }

    @Override
    public EList<EObject> getSources(String role) {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        BasicEList result = new BasicEList();
        for (MappableArtefact artefact : this.getSources()) {
            if (!role.equals(artefact.getName())) continue;
            result.add((Object)artefact.getValue());
        }
        return result;
    }

    @Override
    public EList<EObject> getTargets(String role) {
        if (role == null) {
            throw new IllegalArgumentException("role must not be null");
        }
        BasicEList result = new BasicEList();
        for (MappableArtefact artefact : this.getTargets()) {
            if (!role.equals(artefact.getName())) continue;
            result.add((Object)artefact.getValue());
        }
        return result;
    }

    @Override
    public EList<Link> getLinks(Context rule) {
        LinkedHashSet<Link> resultSet = new LinkedHashSet<Link>();
        LinkedBlockingQueue<Link> toExplore = new LinkedBlockingQueue<Link>();
        toExplore.add(this);
        while (!toExplore.isEmpty()) {
            Link current = (Link)toExplore.poll();
            if (rule == current.getRationale()) {
                resultSet.add(current);
            }
            toExplore.addAll((Collection<Link>)current.getSubLinks());
        }
        BasicEList result = new BasicEList(resultSet);
        return result;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSubLinks()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getSources()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getTargets()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSubLinks();
            }
            case 1: {
                if (resolve) {
                    return this.getRationale();
                }
                return this.basicGetRationale();
            }
            case 2: {
                return this.getSources();
            }
            case 3: {
                return this.getTargets();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getSubLinks().clear();
                this.getSubLinks().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setRationale((Context)newValue);
                return;
            }
            case 2: {
                this.getSources().clear();
                this.getSources().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getTargets().clear();
                this.getTargets().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getSubLinks().clear();
                return;
            }
            case 1: {
                this.setRationale(null);
                return;
            }
            case 2: {
                this.getSources().clear();
                return;
            }
            case 3: {
                this.getTargets().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.subLinks != null && !this.subLinks.isEmpty();
            }
            case 1: {
                return this.rationale != null;
            }
            case 2: {
                return this.sources != null && !this.sources.isEmpty();
            }
            case 3: {
                return this.targets != null && !this.targets.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getUniqueSourceValue((String)arguments.get(0));
            }
            case 1: {
                return this.getUniqueTargetValue((String)arguments.get(0));
            }
            case 2: {
                return this.getSources((String)arguments.get(0));
            }
            case 3: {
                return this.getTargets((String)arguments.get(0));
            }
            case 4: {
                return this.getLinks((Context)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        StringWriter w = new StringWriter();
        w.write("(");
        w.write("sources[");
        for (MappableArtefact s : this.getSources()) {
            w.write(s.getName());
            w.write(": ");
            w.write(s.getValue().toString());
        }
        w.write("]");
        w.write(", targets[");
        for (MappableArtefact s : this.getTargets()) {
            w.write(s.getName());
            w.write(": ");
            w.write(s.getValue().toString());
        }
        w.write("]");
        w.write(")");
        return w.toString();
    }
}

