/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTClassVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAmbiguousUsingDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;

public class CPPASTCompositeTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTCompositeTypeSpecifier {
    private int fKey;
    private IASTName fName;
    private CPPClassScope fScope;
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fDeclarationsPos = -1;
    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecs;
    private int baseSpecsPos = -1;
    private boolean fAmbiguitiesResolved;
    private ICPPASTClassVirtSpecifier virtSpecifier;

    public CPPASTCompositeTypeSpecifier() {
    }

    public CPPASTCompositeTypeSpecifier(int k, IASTName n) {
        this.fKey = k;
        this.setName(n);
    }

    public void setAmbiguitiesResolved() {
        if (!this.fAmbiguitiesResolved && this.fScope != null) {
            this.fScope.createImplicitMembers();
        }
        this.fAmbiguitiesResolved = true;
    }

    @Override
    public CPPASTCompositeTypeSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCompositeTypeSpecifier copy(IASTNode.CopyStyle style) {
        CPPASTCompositeTypeSpecifier copy = new CPPASTCompositeTypeSpecifier(this.fKey, this.fName == null ? null : this.fName.copy(style));
        IASTNode[] iASTNodeArray = this.getMembers();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTNodeArray[n2];
            copy.addMemberDeclaration(member == null ? null : member.copy(style));
            ++n2;
        }
        iASTNodeArray = this.getBaseSpecifiers();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode baseSpecifier = iASTNodeArray[n2];
            copy.addBaseSpecifier(baseSpecifier == null ? null : baseSpecifier.copy(style));
            ++n2;
        }
        copy.setVirtSpecifier(this.virtSpecifier == null ? null : this.virtSpecifier.copy(style));
        return super.copy(copy, style);
    }

    @Override
    public ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] getBaseSpecifiers() {
        if (this.baseSpecs == null) {
            return ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.EMPTY_BASESPECIFIER_ARRAY;
        }
        this.baseSpecs = ArrayUtil.trimAt(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, this.baseSpecsPos);
        return this.baseSpecs;
    }

    @Override
    public void addBaseSpecifier(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpec) {
        this.assertNotFrozen();
        if (baseSpec != null) {
            baseSpec.setParent(this);
            baseSpec.setPropertyInParent(BASE_SPECIFIER);
            this.baseSpecs = ArrayUtil.appendAt(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, ++this.baseSpecsPos, baseSpec);
        }
    }

    @Override
    public int getKey() {
        return this.fKey;
    }

    @Override
    public void setKey(int key) {
        this.assertNotFrozen();
        this.fKey = key;
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    @Override
    public IASTDeclaration[] getMembers() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fDeclarationsPos + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    @Override
    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = ArrayUtil.trimAt(IASTDeclaration.class, this.fAllDeclarations, this.fDeclarationsPos);
            return this.fAllDeclarations;
        }
        return this.getMembers();
    }

    @Override
    public void addMemberDeclaration(IASTDeclaration decl) {
        if (decl == null) {
            return;
        }
        if (decl instanceof ICPPASTVisibilityLabel && !decl.isActive()) {
            return;
        }
        this.assertNotFrozen();
        decl.setParent(this);
        decl.setPropertyInParent(decl instanceof ICPPASTVisibilityLabel ? VISIBILITY_LABEL : MEMBER_DECLARATION);
        this.fAllDeclarations = ArrayUtil.appendAt(IASTDeclaration.class, this.fAllDeclarations, ++this.fDeclarationsPos, decl);
        this.fActiveDeclarations = null;
    }

    @Override
    public final void addDeclaration(IASTDeclaration decl) {
        IASTName segmentName;
        ICPPASTNameSpecifier iCPPASTNameSpecifier;
        ICPPASTQualifiedName qName;
        ICPPASTNameSpecifier[] qualifier;
        ICPPASTUsingDeclaration using;
        IASTName iASTName;
        if (decl instanceof ICPPASTUsingDeclaration && (iASTName = (using = (ICPPASTUsingDeclaration)decl).getName()) instanceof ICPPASTQualifiedName && (qualifier = (qName = (ICPPASTQualifiedName)iASTName).getQualifier()).length > 0 && (iCPPASTNameSpecifier = qualifier[qualifier.length - 1]) instanceof IASTName && CharArrayUtils.equals((segmentName = (IASTName)((Object)iCPPASTNameSpecifier)).getSimpleID(), qName.getLastName().getSimpleID())) {
            decl = new CPPASTAmbiguousUsingDeclaration(decl);
        }
        this.addMemberDeclaration(decl);
    }

    @Override
    public ICPPClassScope getScope() {
        if (this.fScope == null) {
            this.fScope = new CPPClassScope(this);
            if (this.fAmbiguitiesResolved) {
                this.fScope.createImplicitMembers();
            }
        }
        return this.fScope;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (this.virtSpecifier != null && !this.virtSpecifier.accept(action)) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases = this.getBaseSpecifiers();
        int i = 0;
        while (i < bases.length) {
            if (!bases[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTDeclaration[] decls = this.getDeclarations(action.includeInactiveNodes);
        int i2 = 0;
        while (i2 < decls.length) {
            if (!decls[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        return !action.shouldVisitDeclSpecifiers || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName name) {
        if (name == this.fName) {
            return 2;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fDeclarationsPos) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
        super.replace(child, other);
    }

    @Override
    public boolean isFinal() {
        return this.virtSpecifier != null;
    }

    @Override
    @Deprecated
    public void setFinal(boolean value) {
        this.assertNotFrozen();
    }

    @Override
    public ICPPASTClassVirtSpecifier getVirtSpecifier() {
        return this.virtSpecifier;
    }

    @Override
    public void setVirtSpecifier(ICPPASTClassVirtSpecifier virtSpecifier) {
        this.assertNotFrozen();
        this.virtSpecifier = virtSpecifier;
        if (virtSpecifier != null) {
            virtSpecifier.setParent(this);
            virtSpecifier.setPropertyInParent(CLASS_VIRT_SPECIFIER);
        }
    }
}

