/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.cdt.lsp.clangd.internal.config.ClangdConfigFileChecker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ClangdConfigFileMonitor {
    private static final String CLANGD_CONFIG_FILE = ".clangd";
    private final ConcurrentLinkedQueue<IFile> pendingFiles = new ConcurrentLinkedQueue();
    private final IWorkspace workspace;
    private final ClangdConfigFileChecker checker = new ClangdConfigFileChecker();
    private final IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getDelta() != null && event.getType() == 1) {
                try {
                    event.getDelta().accept(delta -> {
                        IResource iResource;
                        if ((delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) && ClangdConfigFileMonitor.CLANGD_CONFIG_FILE.equals(delta.getResource().getName()) && (iResource = delta.getResource()) instanceof IFile) {
                            IFile file = (IFile)iResource;
                            ClangdConfigFileMonitor.this.pendingFiles.add(file);
                            ClangdConfigFileMonitor.this.checkJob.schedule(100L);
                        }
                        return true;
                    });
                }
                catch (CoreException e) {
                    Platform.getLog(this.getClass()).log(e.getStatus());
                }
            }
        }
    };
    private final WorkspaceJob checkJob = new WorkspaceJob("Check .clangd file"){

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            while (ClangdConfigFileMonitor.this.pendingFiles.peek() != null) {
                ClangdConfigFileMonitor.this.checker.checkConfigFile(ClangdConfigFileMonitor.this.pendingFiles.poll());
            }
            return Status.OK_STATUS;
        }
    };

    public ClangdConfigFileMonitor(IWorkspace workspace) {
        this.workspace = workspace;
    }

    public ClangdConfigFileMonitor start() {
        this.workspace.addResourceChangeListener(this.listener);
        return this;
    }

    public void stop() {
        this.workspace.removeResourceChangeListener(this.listener);
    }
}

