/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.internal.InternalDraw2dUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FigureUtilities {
    private static final float RGB_VALUE_MULTIPLIER = 0.6f;
    private static GC gc;
    private static Shell shell;
    private static Font appliedFont;
    private static FontMetrics metrics;
    private static Color ghostFillColor;

    static {
        ghostFillColor = new Color(null, 31, 31, 31);
    }

    public static Color darker(Color color) {
        return new Color(null, (int)((float)color.getRed() * 0.6f), (int)((float)color.getGreen() * 0.6f), (int)((float)color.getBlue() * 0.6f));
    }

    public static FontMetrics getFontMetrics(Font f) {
        FigureUtilities.setFont(f);
        if (metrics == null) {
            metrics = gc.getFontMetrics();
        }
        return metrics;
    }

    @Deprecated
    protected static GC getGC() {
        if (gc == null) {
            gc = new GC((Drawable)FigureUtilities.getShell());
            appliedFont = gc.getFont();
        }
        return gc;
    }

    private static Shell getShell() {
        if (shell == null || shell.isDisposed()) {
            shell = new Shell();
            shell.addDisposeListener(event -> {
                if (gc != null) {
                    gc.dispose();
                    gc = null;
                }
            });
            InternalDraw2dUtils.configureForAutoscalingMode((Control)shell, event -> {});
        }
        return shell;
    }

    protected static org.eclipse.swt.graphics.Point getTextDimension(String s, Font f) {
        FigureUtilities.setFont(f);
        return gc.textExtent(s);
    }

    public static IFigure getRoot(IFigure figure) {
        while (figure.getParent() != null) {
            figure = figure.getParent();
        }
        return figure;
    }

    protected static org.eclipse.swt.graphics.Point getStringDimension(String s, Font f) {
        FigureUtilities.setFont(f);
        return gc.stringExtent(s);
    }

    public static Dimension getTextExtents(String text, Font f) {
        return new Dimension(FigureUtilities.getTextDimension(text, f));
    }

    public static Dimension getStringExtents(String s, Font f) {
        return new Dimension(FigureUtilities.getStringDimension(s, f));
    }

    public static void getTextExtents(String s, Font f, Dimension result) {
        org.eclipse.swt.graphics.Point pt = FigureUtilities.getTextDimension(s, f);
        result.width = pt.x;
        result.height = pt.y;
    }

    public static int getTextWidth(String s, Font f) {
        return FigureUtilities.getTextDimension((String)s, (Font)f).x;
    }

    public static Color lighter(Color rgb) {
        int r = rgb.getRed();
        int g = rgb.getGreen();
        int b = rgb.getBlue();
        return new Color(null, Math.max(2, Math.min((int)((float)r / 0.6f), 255)), Math.max(2, Math.min((int)((float)g / 0.6f), 255)), Math.max(2, Math.min((int)((float)b / 0.6f), 255)));
    }

    public static Shape makeGhostShape(Shape s) {
        s.setBackgroundColor(ghostFillColor);
        s.setFillXOR(true);
        s.setOutlineXOR(true);
        return s;
    }

    public static Color mixColors(Color c1, Color c2, double weight) {
        return new Color(null, (int)((double)c1.getRed() * weight + (double)c2.getRed() * (1.0 - weight)), (int)((double)c1.getGreen() * weight + (double)c2.getGreen() * (1.0 - weight)), (int)((double)c1.getBlue() * weight + (double)c2.getBlue() * (1.0 - weight)));
    }

    public static Color mixColors(Color c1, Color c2) {
        return new Color(null, (c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public static void paintEtchedBorder(Graphics g, Rectangle r, Color shadow, Color highlight) {
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        g.setLineStyle(1);
        g.setLineWidth(1);
        g.setXORMode(false);
        g.setForegroundColor(shadow);
        g.drawRectangle(x, y, w -= 2, h -= 2);
        g.setForegroundColor(highlight);
        g.drawRectangle(++x, ++y, w, h);
    }

    /*
     * Unable to fully structure code
     */
    public static void paintGrid(Graphics g, IFigure f, Point origin, int distanceX, int distanceY) {
        block8: {
            block9: {
                block6: {
                    block7: {
                        clip = g.getClip(Rectangle.SINGLETON);
                        if (distanceX <= 0) break block6;
                        if (origin.x < clip.x) ** GOTO lbl9
                        while (origin.x - distanceX >= clip.x) {
                            origin.x -= distanceX;
                        }
                        break block7;
lbl-1000:
                        // 1 sources

                        {
                            origin.x += distanceX;
lbl9:
                            // 2 sources

                            ** while (origin.x < clip.x)
                        }
                    }
                    i = origin.x;
                    while (i < clip.x + clip.width) {
                        g.drawLine(i, clip.y, i, clip.y + clip.height);
                        i += distanceX;
                    }
                }
                if (distanceY <= 0) break block8;
                if (origin.y < clip.y) ** GOTO lbl24
                while (origin.y - distanceY >= clip.y) {
                    origin.y -= distanceY;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    origin.y += distanceY;
lbl24:
                    // 2 sources

                    ** while (origin.y < clip.y)
                }
            }
            i = origin.y;
            while (i < clip.y + clip.height) {
                g.drawLine(clip.x, i, clip.x + clip.width, i);
                i += distanceY;
            }
        }
    }

    public static void paintEtchedBorder(Graphics g, Rectangle r) {
        Color rgb = g.getBackgroundColor();
        Color shadow = FigureUtilities.darker(rgb);
        Color highlight = FigureUtilities.lighter(rgb);
        FigureUtilities.paintEtchedBorder(g, r, shadow, highlight);
    }

    protected static void setFont(Font f) {
        if (gc != null && !gc.isDisposed() && Objects.equals(appliedFont, f)) {
            return;
        }
        if (gc != null && !gc.isDisposed()) {
            gc.dispose();
        }
        gc = new GC((Drawable)FigureUtilities.getShell());
        gc.setFont(f);
        appliedFont = f;
        metrics = null;
    }

    public static IFigure findCommonAncestor(IFigure l, IFigure r) {
        if (l == r) {
            return l;
        }
        ArrayList<IFigure> left = new ArrayList<IFigure>();
        ArrayList<IFigure> right = new ArrayList<IFigure>();
        while (l != null) {
            left.add(l);
            l = l.getParent();
        }
        while (r != null) {
            right.add(r);
            r = r.getParent();
        }
        if (left.isEmpty() || right.isEmpty()) {
            return null;
        }
        for (IFigure lFigure : left) {
            if (!right.contains(lFigure)) continue;
            return lFigure;
        }
        return null;
    }

    public static boolean isAncestor(IFigure ancestor, IFigure descendant) {
        while (descendant != null) {
            if ((descendant = descendant.getParent()) != ancestor) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotFullyClipped(IFigure figure) {
        if (figure == null || !figure.isShowing()) {
            return false;
        }
        Rectangle figBounds = figure.getBounds().getCopy();
        IFigure walker = figure.getParent();
        while (!figBounds.isEmpty() && walker != null) {
            walker.translateToParent(figBounds);
            figBounds.intersect(walker.getBounds());
            walker = walker.getParent();
        }
        return !figBounds.isEmpty();
    }
}

