/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class JavadocLocationManager {
    public static final String JAVADOC_ID = "org.eclipse.pde.core.javadoc";
    private HashMap<String, Set<String>> fLocations;

    public String getJavadocLocation(IPluginModelBase model) {
        try {
            File file = new File(model.getInstallLocation());
            if (file.isDirectory()) {
                File doc = new File(file, "doc");
                if (new File(doc, "package-list").exists()) {
                    return doc.toURL().toString();
                }
            } else if (CoreUtility.jarContainsResource(file, "doc/package-list", false)) {
                return "jar:" + String.valueOf(file.toURL()) + "!/doc";
            }
            return this.getEntry(model);
        }
        catch (MalformedURLException e) {
            PDECore.log(e);
            return null;
        }
    }

    private synchronized String getEntry(IPluginModelBase model) {
        this.initialize();
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            String id;
            HostSpecification host = desc.getHost();
            String string = id = host == null ? desc.getSymbolicName() : host.getName();
            if (id != null) {
                for (String location : this.fLocations.keySet()) {
                    Set<String> set = this.fLocations.get(location);
                    if (!set.contains(id)) continue;
                    return location;
                }
            }
        }
        return null;
    }

    private synchronized void initialize() {
        IExtension[] extensions;
        if (this.fLocations != null) {
            return;
        }
        this.fLocations = new HashMap();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions(JAVADOC_ID, false);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IPluginModelBase base = PluginRegistry.findModel(extension.getContributor().getName());
            if (base != null && base.getUnderlyingResource() == null) {
                this.processExtension(extension, base);
            }
            ++n2;
        }
    }

    private void processExtension(IExtension extension, IPluginModelBase base) {
        IConfigurationElement[] children;
        IConfigurationElement[] iConfigurationElementArray = children = extension.getConfigurationElements();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("javadoc") && (path = element.getAttribute("path")) != null) {
                try {
                    new URL(path);
                    this.processPlugins(path, element.getChildren());
                }
                catch (MalformedURLException e) {
                    String attr = element.getAttribute("archive");
                    boolean archive = attr == null ? false : "true".equals(attr);
                    IPath modelPath = IPath.fromOSString((String)base.getInstallLocation());
                    StringBuilder buffer = new StringBuilder();
                    File file = modelPath.toFile();
                    if (file.exists()) {
                        try {
                            buffer.append(file.toURI().toURL());
                        }
                        catch (MalformedURLException e1) {
                            buffer.append("file:/");
                            buffer.append(modelPath.toPortableString());
                        }
                        if (file.isFile()) {
                            buffer.append("!/");
                            archive = true;
                        }
                    }
                    buffer.append(path);
                    if (archive) {
                        buffer.insert(0, "jar:");
                        if (buffer.indexOf("!") == -1) {
                            buffer.append("!/");
                        }
                    }
                    this.processPlugins(buffer.toString(), element.getChildren());
                }
            }
            ++n2;
        }
    }

    private void processPlugins(String path, IConfigurationElement[] plugins) {
        IConfigurationElement[] iConfigurationElementArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement plugin = iConfigurationElementArray[n2];
            if (plugin.getName().equals("plugin") && (id = plugin.getAttribute("id")) != null) {
                Set<String> set = this.fLocations.get(path);
                if (set == null) {
                    set = new HashSet<String>();
                    this.fLocations.put(path, set);
                }
                set.add(id);
            }
            ++n2;
        }
    }

    public synchronized void reset() {
        this.fLocations = null;
    }
}

