/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.XDebugExeLaunchConfigurationDelegate;
import org.eclipse.php.internal.debug.core.launching.XDebugWebLaunchConfigurationDelegate;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.XDebugConfigurationDialog;
import org.eclipse.swt.widgets.Shell;

public class XDebugDebuggerConfiguration
extends AbstractDebuggerConfiguration {
    public static final String ID = "org.eclipse.php.debug.core.xdebugDebugger";
    private static final String REMOTE_ENABLE = "remote_enable";
    private static final String EXTENSION_MODULE_ID = "Xdebug";

    @Override
    public String getModuleId() {
        return EXTENSION_MODULE_ID;
    }

    @Override
    public void openConfigurationDialog(Shell parentShell) {
        new XDebugConfigurationDialog(this, parentShell).open();
    }

    @Override
    public int getPort() {
        return XDebugPreferenceMgr.getPort();
    }

    @Override
    public void setPort(int port) {
        XDebugPreferenceMgr.setPort(this.preferences, port);
    }

    @Override
    public String getScriptLaunchDelegateClass() {
        return XDebugExeLaunchConfigurationDelegate.class.getName();
    }

    @Override
    public String getWebLaunchDelegateClass() {
        return XDebugWebLaunchConfigurationDelegate.class.getName();
    }

    @Override
    public void applyDefaults() {
        XDebugPreferenceMgr.applyDefaults(this.preferences);
        this.save();
    }

    @Override
    public IStatus validate(PHPexeItem item) {
        File executable = item.getExecutable();
        PHPexes.changePermissions(executable);
        if (this.isInstalled(item, EXTENSION_MODULE_ID)) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.php.debug.core", PHPDebugCoreMessages.XDebugDebuggerConfiguration_XDebugNotInstalledError);
    }
}

