/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.server.core.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.types.ServerType;
import org.eclipse.php.server.core.types.IServerType;

public class ServerTypesManager {
    private static ServerTypesManager manager;
    private Map<String, IServerType> types;

    private ServerTypesManager() {
    }

    public static synchronized ServerTypesManager getInstance() {
        if (manager == null) {
            manager = new ServerTypesManager();
            manager.init();
        }
        return manager;
    }

    public IServerType getType(String id) {
        return id != null ? this.types.get(id) : this.types.get("org.eclipse.php.server.core.genericServerType");
    }

    public IServerType getType(Server server) {
        return this.getType(server.getAttribute("serverType", null));
    }

    public Collection<IServerType> getAll() {
        return this.types.values();
    }

    private void init() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.server.core.serverType");
        IServerType genericType = null;
        ArrayList<IServerType> result = new ArrayList<IServerType>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IServerType type = null;
            if ("type".equals(element.getName())) {
                type = ServerType.create(element);
            }
            if (type != null) {
                if (type.getId().equals("org.eclipse.php.server.core.genericServerType")) {
                    genericType = type;
                } else {
                    result.add(type);
                }
            }
            ++n2;
        }
        this.types = new LinkedHashMap<String, IServerType>();
        for (IServerType type : result) {
            this.types.put(type.getId(), type);
        }
        if (genericType != null) {
            this.types.put(genericType.getId(), genericType);
        }
    }
}

