/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.ExactMixinSearchPattern;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.PrefixMixinSearchPattern;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyObjectMixinClass;
import org.eclipse.dltk.ruby.typeinference.BuiltinMethodsDatabase;
import org.eclipse.dltk.ruby.typeinference.BuiltinTypeMethods;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubyModelUtils {
    public static IType getModelTypeByAST(TypeDeclaration astNode, ISourceModule sourceModule) throws ModelException {
        IType[] types = sourceModule.getAllTypes();
        int astStart = astNode.sourceStart();
        int astEnd = astNode.sourceEnd();
        int bestScore = Integer.MAX_VALUE;
        IType bestType = null;
        int i = 0;
        while (i < types.length) {
            int diff2;
            int diff1;
            int score;
            IType type = types[i];
            ISourceRange sourceRange = type.getSourceRange();
            int modelStart = sourceRange.getOffset();
            int modelEnd = modelStart + sourceRange.getLength();
            if (modelStart == astStart && modelEnd == astEnd) {
                return type;
            }
            if (type.getElementName().equals(astNode.getName()) && (score = (diff1 = modelStart - astStart) * diff1 + (diff2 = modelEnd - astEnd) * diff2) < bestScore) {
                bestScore = score;
                bestType = type;
            }
            ++i;
        }
        return bestType;
    }

    public static MethodDeclaration getNodeByMethod(ModuleDeclaration rootNode, IMethod method) throws ModelException {
        ISourceRange sourceRange = method.getSourceRange();
        final int modelStart = sourceRange.getOffset();
        final int modelEnd = modelStart + sourceRange.getLength();
        final int modelCutoffStart = modelStart - 100;
        final int modelCutoffEnd = modelEnd + 100;
        final String methodName = method.getElementName();
        final MethodDeclaration[] bestResult = new MethodDeclaration[1];
        ASTVisitor visitor = new ASTVisitor(){
            int bestScore = Integer.MAX_VALUE;

            private boolean interesting(ASTNode s) {
                if (s.sourceStart() < 0 || s.sourceEnd() < s.sourceStart()) {
                    return true;
                }
                return modelCutoffEnd >= s.sourceStart() && modelCutoffStart < s.sourceEnd();
            }

            public boolean visit(Expression s) throws Exception {
                return this.interesting((ASTNode)s);
            }

            public boolean visit(MethodDeclaration s) throws Exception {
                int astEnd;
                int diff2;
                int astStart;
                int diff1;
                int score;
                if (!this.interesting((ASTNode)s)) {
                    return false;
                }
                if (s.getName().equals(methodName) && (score = (diff1 = modelStart - (astStart = s.sourceStart())) * diff1 + (diff2 = modelEnd - (astEnd = s.sourceEnd())) * diff2) < this.bestScore) {
                    this.bestScore = score;
                    bestResult[0] = s;
                }
                return true;
            }

            public boolean visit(ModuleDeclaration s) throws Exception {
                return this.interesting((ASTNode)s);
            }

            public boolean visit(TypeDeclaration s) throws Exception {
                return this.interesting((ASTNode)s);
            }

            public boolean endvisit(TypeDeclaration s) throws Exception {
                if (!this.interesting((ASTNode)s)) {
                    return false;
                }
                return false;
            }

            public boolean visitGeneral(ASTNode s) throws Exception {
                if (s instanceof Block) {
                    return true;
                }
                return this.interesting(s);
            }
        };
        try {
            rootNode.traverse(visitor);
        }
        catch (Exception e) {
            RubyPlugin.log(e);
        }
        return bestResult[0];
    }

    public static IField[] findFields(RubyMixinModel rubyModel, ISourceModule modelModule, ModuleDeclaration parsedUnit, String prefix, int position) {
        Assert.isNotNull((Object)prefix);
        ArrayList<IField> result = new ArrayList<IField>();
        String[] keys = RubyTypeInferencingUtils.getModelStaticScopesKeys(rubyModel.getRawModel(), parsedUnit, position);
        IRubyMixinElement innerElement = null;
        RubyMixinClass selfClass = new RubyObjectMixinClass(rubyModel, true);
        if (keys != null && keys.length > 0) {
            String inner = keys[keys.length - 1];
            if (prefix.length() > 0 && !prefix.startsWith("@")) {
                String varkey = String.valueOf(inner) + MixinModel.SEPARATOR + prefix;
                String[] keys2 = rubyModel.getRawModel().findKeys(String.valueOf(varkey) + "*", (IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < keys2.length) {
                    RubyMixinVariable variable;
                    IField field;
                    IRubyMixinElement element = rubyModel.createRubyElement(keys2[i]);
                    if (element instanceof RubyMixinVariable && (field = (variable = (RubyMixinVariable)element).getSourceFields()[0]).getElementName().startsWith(prefix)) {
                        result.add(field);
                    }
                    ++i;
                }
            } else {
                innerElement = rubyModel.createRubyElement(inner);
                if (innerElement instanceof RubyMixinMethod) {
                    RubyMixinMethod method = (RubyMixinMethod)innerElement;
                    selfClass = method.getSelfType();
                    RubyMixinVariable[] fields2 = method.getVariables();
                    RubyModelUtils.addVariablesFrom(fields2, prefix, result);
                } else if (innerElement instanceof RubyMixinClass) {
                    selfClass = (RubyMixinClass)innerElement;
                }
            }
        }
        if (selfClass != null) {
            RubyMixinVariable[] fields2 = ((RubyMixinClass)selfClass).getFields();
            RubyModelUtils.addVariablesFrom(fields2, prefix, result);
            if (selfClass.getKey().equals("Object")) {
                try {
                    IModelElement[] children = modelModule.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        IField field;
                        if (children[i] instanceof IField && (field = (IField)children[i]).getElementName().startsWith(prefix)) {
                            result.add(field);
                        }
                        ++i;
                    }
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return result.toArray(new IField[result.size()]);
    }

    private static List<IMethod> handleSpecialMethod(RubyMixinMethod method, RubyMixinClass selfKlass) {
        if (method.getKey().equals("Class%{new")) {
            RubyMixinMethod init;
            RubyMixinMethod rubyMixinMethod = init = selfKlass.getInstanceClass() != null ? selfKlass.getInstanceClass().getMethod("initialize") : null;
            if (init != null) {
                IMethod[] initMethods = init.getSourceMethods();
                ArrayList<IMethod> result = new ArrayList<IMethod>();
                int i = 0;
                while (i < initMethods.length) {
                    try {
                        IParameter[] parameters = initMethods[i].getParameters();
                        int flags = initMethods[i].getFlags();
                        ISourceRange sourceRange = initMethods[i].getSourceRange();
                        ISourceRange nameRange = initMethods[i].getNameRange();
                        IModelElement parent = initMethods[i].getParent();
                        FakeMethod newMethod = new FakeMethod((ModelElement)parent, "new", sourceRange.getOffset(), sourceRange.getLength(), nameRange.getOffset(), nameRange.getLength());
                        newMethod.setParameters(parameters);
                        newMethod.setFlags(flags);
                        String receiver = "";
                        if (parent instanceof IType) {
                            IType type = (IType)parent;
                            receiver = type.getTypeQualifiedName("::");
                        }
                        newMethod.setReceiver(receiver);
                        result.add((IMethod)newMethod);
                    }
                    catch (ModelException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    public static List<IMethod> getAllSourceMethods(RubyMixinMethod[] methods, RubyMixinClass selfKlass) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        int i = 0;
        while (i < methods.length) {
            List<IMethod> m;
            if (selfKlass != null && (m = RubyModelUtils.handleSpecialMethod(methods[i], selfKlass)) != null) {
                result.addAll(m);
            } else {
                IMethod[] sourceMethods = methods[i].getSourceMethods();
                int j = 0;
                while (j < sourceMethods.length) {
                    if (sourceMethods[j] != null) {
                        result.add(sourceMethods[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static IMethod[] searchClassMethods(RubyMixinModel mixinModel, ISourceModule modelModule, ModuleDeclaration moduleDeclaration, IEvaluatedType type, String prefix) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        if (type instanceof RubyClassType) {
            RubyClassType rubyClassType = (RubyClassType)type;
            RubyMixinClass rubyClass = mixinModel.createRubyClass(rubyClassType);
            if (rubyClass != null) {
                RubyMixinMethod[] methods = rubyClass.findMethods(new PrefixMixinSearchPattern(prefix));
                result.addAll(RubyModelUtils.getAllSourceMethods(methods, rubyClass));
            }
        } else if (type instanceof AmbiguousType) {
            AmbiguousType type2 = (AmbiguousType)type;
            IEvaluatedType[] possibleTypes = type2.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IMethod[] m = RubyModelUtils.searchClassMethods(mixinModel, modelModule, moduleDeclaration, possibleTypes[i], prefix);
                int j = 0;
                while (j < m.length) {
                    result.add(m[j]);
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IMethod[] searchClassMethodsExact(RubyMixinModel mixinModel, ISourceModule modelModule, ModuleDeclaration moduleDeclaration, IEvaluatedType type, String methodName) {
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        if (type instanceof RubyClassType) {
            RubyClassType rubyClassType = (RubyClassType)type;
            RubyMixinClass rubyClass = mixinModel.createRubyClass(rubyClassType);
            if (rubyClass != null) {
                RubyMixinMethod[] methods = rubyClass.findMethods(new ExactMixinSearchPattern(methodName));
                result.addAll(RubyModelUtils.getAllSourceMethods(methods, rubyClass));
            }
        } else if (type instanceof AmbiguousType) {
            AmbiguousType type2 = (AmbiguousType)type;
            IEvaluatedType[] possibleTypes = type2.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IMethod[] m = RubyModelUtils.searchClassMethodsExact(mixinModel, modelModule, moduleDeclaration, possibleTypes[i], methodName);
                int j = 0;
                while (j < m.length) {
                    result.add(m[j]);
                    ++j;
                }
                ++i;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private static void addVariablesFrom(RubyMixinVariable[] fields2, String prefix, List<IField> resultList) {
        int i = 0;
        while (i < fields2.length) {
            IField[] sourceFields = fields2[i].getSourceFields();
            if (sourceFields != null) {
                int j = 0;
                while (j < sourceFields.length) {
                    if (sourceFields[j] != null && sourceFields[j].getElementName().startsWith(prefix)) {
                        resultList.add(sourceFields[j]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static IMethod[] getSingletonMethods(RubyMixinModel mixinModel, VariableReference receiver, ModuleDeclaration parsedUnit, ISourceModule modelModule, String methodName) {
        IMethod[] res = null;
        String[] scopesKeys = RubyTypeInferencingUtils.getModelStaticScopesKeys(mixinModel.getRawModel(), parsedUnit, receiver.sourceStart());
        if (scopesKeys != null && scopesKeys.length > 0) {
            String possibleName;
            if (scopesKeys.length == 1) {
                possibleName = String.valueOf(receiver.getName()) + "%v";
            } else {
                String last = scopesKeys[scopesKeys.length - 1];
                possibleName = String.valueOf(last) + MixinModel.SEPARATOR + receiver.getName() + "%v";
            }
            IRubyMixinElement element = mixinModel.createRubyElement(possibleName);
            if (element instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)element;
                res = RubyModelUtils.searchClassMethodsExact(mixinModel, modelModule, parsedUnit, (IEvaluatedType)new RubyClassType(rubyMixinClass.getKey()), methodName);
            }
        }
        return res;
    }

    public static FakeMethod[] getFakeMethods(ModelElement parent, String klass) {
        BuiltinMethodsDatabase.Metaclass metaclass = BuiltinMethodsDatabase.get(klass);
        if (metaclass != null) {
            ArrayList<FakeMethod> fakeMethods = new ArrayList<FakeMethod>();
            RubyModelUtils.addFakeMethods(parent, metaclass, fakeMethods);
            return fakeMethods.toArray(new FakeMethod[fakeMethods.size()]);
        }
        String[] names = RubyModelUtils.getBuiltinMethodNames(klass);
        if (names == null) {
            return new FakeMethod[0];
        }
        ArrayList<FakeMethod> methods = new ArrayList<FakeMethod>();
        int i = 0;
        while (i < names.length) {
            FakeMethod method = new FakeMethod(parent, names[i]);
            method.setReceiver(klass);
            methods.add(method);
            ++i;
        }
        return methods.toArray(new FakeMethod[methods.size()]);
    }

    private static void addFakeMethods(ModelElement parent, BuiltinMethodsDatabase.Metaclass metaclass, List<FakeMethod> fakeMethods) {
        BuiltinMethodsDatabase.ClassMetaclass classMeta;
        BuiltinMethodsDatabase.ClassMetaclass superClass;
        BuiltinMethodsDatabase.ModuleMetaclass[] includedModules = metaclass.getIncludedModules();
        int i = 0;
        while (i < includedModules.length) {
            BuiltinMethodsDatabase.ModuleMetaclass module = includedModules[i];
            RubyModelUtils.addFakeMethods(parent, module, fakeMethods);
            ++i;
        }
        BuiltinMethodsDatabase.MethodInfo[] methods = metaclass.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            BuiltinMethodsDatabase.MethodInfo info = methods[i2];
            FakeMethod method = RubyModelUtils.createFakeMethod(parent, metaclass, info);
            fakeMethods.add(method);
            ++i2;
        }
        if (metaclass instanceof BuiltinMethodsDatabase.ClassMetaclass && (superClass = (classMeta = (BuiltinMethodsDatabase.ClassMetaclass)metaclass).getSuperClass()) != null) {
            RubyModelUtils.addFakeMethods(parent, superClass, fakeMethods);
        }
    }

    private static FakeMethod createFakeMethod(ModelElement parent, BuiltinMethodsDatabase.Metaclass metaclass, BuiltinMethodsDatabase.MethodInfo info) {
        IParameter[] parameters;
        FakeMethod method = new FakeMethod(parent, info.getName());
        method.setFlags(info.getFlags());
        int arity = info.getArity();
        if (arity > 0) {
            parameters = new IParameter[arity];
            int i = 0;
            while (i < arity) {
                parameters[i] = new MethodParameterInfo("arg" + (i + 1));
                ++i;
            }
        } else if (arity < 0) {
            parameters = new IParameter[-arity];
            int i = 0;
            while (i < -arity - 1) {
                parameters[i] = new MethodParameterInfo("arg" + (i + 1));
                ++i;
            }
            parameters[-arity - 1] = new MethodParameterInfo("...");
        } else {
            parameters = new IParameter[]{};
        }
        method.setParameters(parameters);
        method.setReceiver(metaclass.getName());
        return method;
    }

    public static FakeMethod[] getFakeMetaMethods(ModelElement parent, String klass) {
        BuiltinMethodsDatabase.Metaclass metaclass = BuiltinMethodsDatabase.get(klass);
        if (metaclass != null) {
            BuiltinMethodsDatabase.ClassMetaclass metaMetaclass = metaclass.getMetaClass();
            ArrayList<FakeMethod> fakeMethods = new ArrayList<FakeMethod>();
            RubyModelUtils.addFakeMethods(parent, metaMetaclass, fakeMethods);
            return fakeMethods.toArray(new FakeMethod[fakeMethods.size()]);
        }
        String[] names = RubyModelUtils.getBuiltinMetaMethodNames(klass);
        if (names == null) {
            return new FakeMethod[0];
        }
        ArrayList<FakeMethod> methods = new ArrayList<FakeMethod>();
        int i = 0;
        while (i < names.length) {
            FakeMethod method = new FakeMethod(parent, names[i]);
            method.setReceiver(klass);
            methods.add(method);
            ++i;
        }
        return methods.toArray(new FakeMethod[methods.size()]);
    }

    public static String[] getBuiltinMethodNames(String klass) {
        if (klass.equals("Object")) {
            return BuiltinTypeMethods.objectMethods;
        }
        if (klass.equals("String")) {
            return BuiltinTypeMethods.stringMethods;
        }
        if (klass.equals("Fixnum")) {
            return BuiltinTypeMethods.fixnumMethods;
        }
        if (klass.equals("Float")) {
            return BuiltinTypeMethods.floatMethods;
        }
        if (klass.equals("Regexp")) {
            return BuiltinTypeMethods.regexpMethods;
        }
        if (klass.equals("Array")) {
            return BuiltinTypeMethods.arrayMethods;
        }
        return null;
    }

    public static String[] getBuiltinMetaMethodNames(String klass) {
        if (klass.equals("Object")) {
            return BuiltinMethodsDatabase.objectMethods;
        }
        return null;
    }

    public static IType[] findTopLevelTypes(ISourceModule module, String namePrefix) {
        ArrayList<IType> result = new ArrayList<IType>();
        try {
            IModelElement[] children = module.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IType && children[i].getElementName().startsWith(namePrefix)) {
                    result.add((IType)children[i]);
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IField[] findTopLevelFields(ISourceModule module, String namePrefix) {
        ArrayList<IField> result = new ArrayList<IField>();
        try {
            IModelElement[] children = module.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IField && children[i].getElementName().startsWith(namePrefix)) {
                    result.add((IField)children[i]);
                }
                ++i;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] findTopLevelMethods(IScriptProject project, String namePattern) {
        ArrayList result;
        block2: {
            result = new ArrayList();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IMethod meth;
                    Object element = match.getElement();
                    if (element instanceof IMethod && (meth = (IMethod)element).getParent() instanceof ISourceModule) {
                        result.add(meth);
                    }
                }
            };
            SearchPattern pattern = SearchPattern.createPattern((String)namePattern, (int)1, (int)0, (int)2, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)project));
            IDLTKSearchScope scope = project != null ? SearchEngine.createSearchScope((IModelElement)project) : SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)RubyLanguageToolkit.getDefault());
            try {
                SearchEngine engine = new SearchEngine();
                engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static String evaluateSuperClass(IType type) {
        String[] superClasses;
        String superclass = null;
        try {
            superClasses = type.getSuperClasses();
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
        if (superClasses != null && superClasses.length > 0) {
            superclass = superClasses[0];
            if (superclass.startsWith("::")) {
                superclass = superclass.substring(2);
            }
            superclass = superclass.replaceAll("::", "{");
        }
        return superclass;
    }
}

