/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.OrMatchingPredicate;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.OrPattern;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.dltk.javascript.internal.search.FieldPredicate;
import org.eclipse.dltk.javascript.internal.search.LocalVariablePredicate;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodPredicate;
import org.eclipse.dltk.javascript.internal.search.TypeReferencePredicate;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;

public class MatchingPredicateFactory {
    static IMatchingPredicate<MatchingNode> create(ITypeInfoContext context, SearchPattern pattern) {
        if (pattern instanceof FieldPattern) {
            return new FieldPredicate((FieldPattern)pattern);
        }
        if (pattern instanceof MethodPattern) {
            return new MethodPredicate((MethodPattern)pattern);
        }
        if (pattern instanceof MethodDeclarationPattern) {
            return new MethodPredicate((MethodDeclarationPattern)pattern);
        }
        if (pattern instanceof TypeReferencePattern) {
            return new TypeReferencePredicate(context, (TypeReferencePattern)pattern);
        }
        if (pattern instanceof LocalVariablePattern) {
            return new LocalVariablePredicate((LocalVariablePattern)pattern);
        }
        if (pattern instanceof OrPattern) {
            OrMatchingPredicate predicate = new OrMatchingPredicate();
            SearchPattern[] searchPatternArray = ((OrPattern)pattern).getPatterns();
            int n = searchPatternArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchPattern p = searchPatternArray[n2];
                IMatchingPredicate<MatchingNode> pp = MatchingPredicateFactory.create(context, p);
                if (pp != null) {
                    predicate.addPredicate(pp);
                }
                ++n2;
            }
            return predicate.optimize();
        }
        return null;
    }
}

