/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

public class ClassicalForStatement
extends Statement {
    private Expression fInitialization;
    private Expression fCondition;
    private Expression fIncrement;
    private Statement fAction;

    public ClassicalForStatement(DLTKToken forToken, Expression initialization, Expression condition, Expression increment, Statement action) {
        this.fInitialization = initialization;
        this.fCondition = condition;
        this.fIncrement = increment;
        this.fAction = action;
        this.setStart(forToken.getColumn());
        if (action != null) {
            this.setEnd(action.sourceEnd());
        }
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Statement)this)) {
            if (this.fInitialization != null) {
                this.fInitialization.traverse(pVisitor);
            }
            if (this.fCondition != null) {
                this.fCondition.traverse(pVisitor);
            }
            if (this.fIncrement != null) {
                this.fIncrement.traverse(pVisitor);
            }
            if (this.fAction != null) {
                this.fAction.traverse(pVisitor);
            }
            pVisitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 2001;
    }

    public Statement getAction() {
        return this.fAction;
    }

    public Expression getCondition() {
        return this.fCondition;
    }

    public Expression getIncrement() {
        return this.fIncrement;
    }

    public Expression getInitialization() {
        return this.fInitialization;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("for:");
        if (this.fCondition != null) {
            output.formatPrintLn("condition:");
            this.fCondition.printNode(output);
        }
        if (this.fIncrement != null) {
            output.formatPrintLn("increment:");
            this.fIncrement.printNode(output);
        }
        if (this.fInitialization != null) {
            output.formatPrintLn("initialization:");
            this.fInitialization.printNode(output);
        }
        if (this.fAction != null) {
            output.indent();
            this.fAction.printNode(output);
            output.dedent();
        }
    }
}

