/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.parser.visitors;

import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.python.parser.ast.PythonYieldStatement;
import org.eclipse.dltk.python.parser.ast.expressions.BinaryExpression;
import org.eclipse.dltk.python.parser.ast.expressions.NotStrictAssignment;
import org.eclipse.dltk.python.parser.ast.expressions.PythonForListExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportAsExpression;

public class PythonVersionReportVisitor
extends ASTVisitor {
    public static final int VERSION_15x = 261;
    public static final int VERSION_20x = 512;
    public static final int VERSION_21x = 513;
    public static final int VERSION_22x = 514;
    public static final int VERSION_23x = 515;
    public static final int VERSION_24x = 516;
    private int fCurrentVersion = 261;
    private int fProjectVersion = 0;

    public PythonVersionReportVisitor(int version) {
        this.fProjectVersion = version;
    }

    public int getRequredVersion() {
        return this.fCurrentVersion;
    }

    public String getRequestedVersionStr() {
        return this.getVersionStr(this.fCurrentVersion);
    }

    public String getVersionStr(int version) {
        if (version < 261) {
            return "Python <= 1.5.x";
        }
        if (version >= 261 && version < 512) {
            return "Python >=1.5.x and < 2.0.0 ";
        }
        if (version >= 512 && version < 513) {
            return "Python 2.0.x ";
        }
        if (version >= 513 && version < 514) {
            return "Python >=2.1.x and < 2.2.0 ";
        }
        if (version >= 514 && version < 515) {
            return "Python >=2.2.x and < 2.3.0 ";
        }
        if (version >= 515 && version < 516) {
            return "Python >=2.3.x and < 2.4.0 ";
        }
        if (version >= 516) {
            return "Python >=2.4.x";
        }
        return "Python version not determined.";
    }

    public boolean visit(Expression expression) throws Exception {
        BinaryExpression binaryExpression;
        if (expression instanceof NotStrictAssignment) {
            switch (expression.getKind()) {
                case 1031: 
                case 1032: 
                case 1034: 
                case 1036: 
                case 1037: 
                case 1038: 
                case 1039: 
                case 1041: 
                case 1047: 
                case 1076: {
                    this.requreVersion(512, (Statement)expression);
                    break;
                }
                case 1040: 
                case 1077: {
                    this.requreVersion(514, (Statement)expression);
                }
            }
        }
        if (expression instanceof BinaryExpression && (binaryExpression = (BinaryExpression)expression).getKind() == 1019) {
            this.requreVersion(514, (Statement)expression);
        }
        if (expression instanceof PythonForListExpression || expression instanceof PythonForListExpression) {
            this.requreVersion(512, (Statement)expression);
        }
        if (expression instanceof PythonImportAsExpression) {
            this.requreVersion(513, (Statement)expression);
        }
        return true;
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        List decorators = s.getDecorators();
        if (decorators != null && decorators.size() > 0) {
            this.requreVersion(516, (Statement)s);
        }
        return true;
    }

    private void requreVersion(int version, Statement statement) {
        if (this.fCurrentVersion < version) {
            this.fCurrentVersion = version;
        }
        if (this.fCurrentVersion > this.fProjectVersion) {
            System.out.println("Project requred version:" + statement.toString());
        }
    }

    public boolean visit(Statement statement) throws Exception {
        if (statement instanceof PythonYieldStatement) {
            this.requreVersion(514, statement);
        }
        return true;
    }
}

