/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.python.parser.ast.PythonImportFromStatement;
import org.eclipse.dltk.python.parser.ast.PythonImportStatement;
import org.eclipse.dltk.python.parser.ast.expressions.Assignment;
import org.eclipse.dltk.python.parser.ast.expressions.ExtendedVariableReference;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportAsExpression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonImportExpression;

public class PythonASTFindVisitor
extends ASTVisitor {
    private String fName = null;
    private List fAppropriateNodes = new ArrayList();
    private Map fParentsMap = new HashMap();
    private boolean fDontVisitMethods = false;
    private int innerCount = 0;
    List fParents = new ArrayList();

    public PythonASTFindVisitor(String name) {
        this.fName = name;
    }

    public PythonASTFindVisitor(String name, boolean dontVisitClassOrMethod) {
        this.fName = name;
        this.fDontVisitMethods = dontVisitClassOrMethod;
    }

    void putChild(ASTNode node) {
        ASTNode parent = null;
        if (this.fParents.size() > 0) {
            parent = (ASTNode)this.fParents.get(this.fParents.size() - 1);
        }
        this.fParentsMap.put(node, parent);
    }

    void putPrevChild(ASTNode node) {
        ASTNode parent = null;
        if (this.fParents.size() > 1) {
            parent = (ASTNode)this.fParents.get(this.fParents.size() - 2);
        }
        this.fParentsMap.put(node, parent);
    }

    public List getNodes() {
        return this.fAppropriateNodes;
    }

    public Map getParents() {
        return this.fParentsMap;
    }

    public boolean visit(Expression expression) throws Exception {
        this.putChild((ASTNode)expression);
        if (expression instanceof Assignment) {
            ExtendedVariableReference ref;
            this.fParents.add(expression);
            Assignment assignment = (Assignment)expression;
            Statement left = assignment.getLeft();
            if (left instanceof SimpleReference && ((SimpleReference)left).getName().equals(this.fName)) {
                this.fAppropriateNodes.add(expression);
            }
            if (left instanceof ExtendedVariableReference && (ref = (ExtendedVariableReference)left).isDot(0)) {
                Expression first = ref.getExpression(0);
                Expression second = ref.getExpression(1);
                if (first instanceof VariableReference && ((VariableReference)first).getName().equals("self") && second instanceof VariableReference && ((VariableReference)second).getName().equals(this.fName)) {
                    this.fAppropriateNodes.add(expression);
                    List expressions = ref.getExpressions();
                    Iterator i = expressions.iterator();
                    while (i.hasNext()) {
                        Expression exp = (Expression)i.next();
                        this.fParentsMap.put(exp, ref);
                    }
                }
            }
        } else {
            if (expression instanceof ExtendedVariableReference) {
                ExtendedVariableReference ref = (ExtendedVariableReference)expression;
                List expressions = ref.getExpressions();
                Iterator i = expressions.iterator();
                while (i.hasNext()) {
                    Expression exp = (Expression)i.next();
                    this.fParentsMap.put(exp, ref);
                }
                return false;
            }
            this.fParents.add(expression);
        }
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        ++this.innerCount;
        if (this.innerCount > 1 && this.fDontVisitMethods) {
            --this.innerCount;
            return false;
        }
        this.putChild((ASTNode)method);
        this.fParents.add(method);
        if (method.getName().equals(this.fName)) {
            this.fAppropriateNodes.add(method);
        }
        return true;
    }

    public boolean visit(Statement statement) throws Exception {
        Statement importStatement;
        Map importedAsNames;
        if (statement instanceof Argument) {
            this.putPrevChild((ASTNode)statement);
        } else {
            this.putChild((ASTNode)statement);
        }
        if (statement instanceof PythonImportFromStatement && (importedAsNames = (importStatement = (PythonImportFromStatement)statement).getImportedAsNames()).containsValue(this.fName)) {
            this.fAppropriateNodes.add(statement);
            return false;
        }
        if (statement instanceof PythonImportStatement) {
            importStatement = (PythonImportStatement)statement;
            List imports = importStatement.getImports();
            Iterator i = imports.iterator();
            while (i.hasNext()) {
                Expression imp = (Expression)i.next();
                String name = "";
                if (imp instanceof PythonImportExpression) {
                    name = ((PythonImportExpression)imp).getName();
                } else if (imp instanceof PythonImportAsExpression) {
                    name = ((PythonImportAsExpression)imp).getAsName();
                }
                if (!name.equals(this.fName)) continue;
                this.fAppropriateNodes.add(statement);
                break;
            }
            return false;
        }
        this.fParents.add(statement);
        return true;
    }

    public boolean visit(ModuleDeclaration declaration) throws Exception {
        ++this.innerCount;
        if (this.innerCount > 1 && this.fDontVisitMethods) {
            --this.innerCount;
            return false;
        }
        this.fParents.add(declaration);
        return true;
    }

    public boolean visit(TypeDeclaration typeDeclaration) throws Exception {
        ++this.innerCount;
        if (this.innerCount > 1 && this.fDontVisitMethods) {
            --this.innerCount;
            return false;
        }
        this.putChild((ASTNode)typeDeclaration);
        this.fParents.add(typeDeclaration);
        if (typeDeclaration.getName().equals(this.fName)) {
            this.fAppropriateNodes.add(typeDeclaration);
        }
        return true;
    }

    public boolean endvisit(Expression s) throws Exception {
        this.fParents.remove(s);
        return true;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        --this.innerCount;
        this.fParents.remove(method);
        return true;
    }

    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        --this.innerCount;
        this.fParents.remove(declaration);
        return true;
    }

    public boolean endvisit(Statement statement) throws Exception {
        this.fParents.remove(statement);
        return true;
    }

    public boolean endvisit(TypeDeclaration typeDeclaration) throws Exception {
        --this.innerCount;
        this.fParents.remove(typeDeclaration);
        return true;
    }
}

