/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IModelElementVisitorExtension;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.matching.IMatchLocator;
import org.eclipse.dltk.core.search.matching.ModuleFactory;
import org.eclipse.dltk.core.search.matching2.IMatchingNodeSet;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.core.search.matching2.MatchingCollector;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.internal.search.JavaScriptMatchLocatorVisitor;
import org.eclipse.dltk.javascript.internal.search.JavaScriptMatchingNodeSet;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MatchingPredicateFactory;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;

public class JavaScriptMatchLocator
implements IMatchLocator,
IModelElementVisitor,
IModelElementVisitorExtension {
    private static final boolean VERBOSE = false;
    private IProgressMonitor progressMonitor;
    private SearchRequestor requestor;
    private IDLTKSearchScope scope;
    private SearchPattern pattern;
    private JavaScriptMatchingNodeSet nodeSet = new JavaScriptMatchingNodeSet();
    private SearchParticipant participant;

    public void initialize(SearchPattern pattern, IDLTKSearchScope scope) {
        this.pattern = pattern;
        this.scope = scope;
    }

    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        Assert.isNotNull((Object)this.requestor);
        ModuleFactory moduleFactory = new ModuleFactory(this.scope);
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        IMatchingPredicate<MatchingNode> predicate = MatchingPredicateFactory.create(inferencer2, this.pattern);
        if (predicate == null) {
            return;
        }
        MatchingCollector matchingCollector = new MatchingCollector(predicate, (IMatchingNodeSet)this.nodeSet);
        SearchDocument[] searchDocumentArray = searchDocuments;
        int n = searchDocuments.length;
        int n2 = 0;
        while (n2 < n) {
            SearchDocument document = searchDocumentArray[n2];
            ISourceModule module = moduleFactory.create(document);
            if (module != null) {
                JavaScriptMatchLocatorVisitor visitor = new JavaScriptMatchLocatorVisitor(ReferenceSource.create((IModelElement)module));
                this.nodeSet.clear();
                Script script = JavaScriptParserUtil.parse((ISourceModule)module);
                visitor.visitScript(script);
                visitor.resolveMatchingNodes(inferencer2, script, module);
                visitor.report((MatchingCollector<MatchingNode>)matchingCollector);
                if (!this.nodeSet.isEmpty()) {
                    this.resolvePotentialMatches(predicate);
                    this.participant = document.getParticipant();
                    module.accept((IModelElementVisitor)this);
                    for (MatchingNode matchingNode : this.nodeSet.matchingNodes()) {
                        MatchLevel level = this.nodeSet.removeTrustedMatch(matchingNode);
                        if (level == null) continue;
                        this.requestor.acceptSearchMatch(matchingNode.createMatch((IModelElement)module, this.participant, level));
                    }
                } else if (DLTKCore.DEBUG) {
                    JavaScriptPlugin.warning("No matches located in " + document);
                }
            }
            ++n2;
        }
    }

    private void resolvePotentialMatches(IMatchingPredicate<MatchingNode> predicate) {
        for (MatchingNode node : this.nodeSet.getPossibleMatchingNodes()) {
            MatchLevel level = predicate.resolvePotentialMatch((Object)node);
            if (level == null || level == MatchLevel.POSSIBLE_MATCH) continue;
            this.nodeSet.addMatch(node, level);
        }
        this.nodeSet.clearPossibleMatchingNodes();
    }

    public boolean visit(IModelElement element) {
        return element instanceof ISourceModule || element instanceof IMember;
    }

    public void endVisit(IModelElement element) {
        if (!(element instanceof IMember)) {
            return;
        }
        try {
            ISourceRange range = ((ISourceReference)element).getSourceRange();
            List matchingNodes = this.nodeSet.matchingNodes(range.getOffset(), range.getOffset() + range.getLength());
            for (MatchingNode node : matchingNodes) {
                MatchLevel level = this.nodeSet.removeTrustedMatch(node);
                if (level == null) continue;
                this.requestor.acceptSearchMatch(node.createMatch(element, this.participant, level));
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.error(e);
        }
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void setRequestor(SearchRequestor requestor) {
        this.requestor = requestor;
    }
}

