/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.FunctionValueCollection;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.JSElement;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.JSVariable;
import org.eclipse.dltk.internal.javascript.ti.LazyTypeReference;
import org.eclipse.dltk.internal.javascript.ti.NestedValueCollection;
import org.eclipse.dltk.internal.javascript.ti.ThisValue;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitorBase;
import org.eclipse.dltk.internal.javascript.ti.WithValueCollection;
import org.eclipse.dltk.internal.javascript.ti.XMLListValue;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlExpressionFragment;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.internal.core.RRecordMember;
import org.eclipse.dltk.javascript.parser.ISuppressWarningsState;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTags;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.IFunctionValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.PhantomValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinference.ValueReferenceUtil;
import org.eclipse.dltk.javascript.typeinfo.CommonSuperTypeFinder;
import org.eclipse.dltk.javascript.typeinfo.E4XTypes;
import org.eclipse.dltk.javascript.typeinfo.GenericMethodTypeInferencer;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilderExtension;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.GenericMethod;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableClassType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.dltk.javascript.typeinfo.model.util.TypeInfoModelSwitch;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TypeInferencerVisitor
extends TypeInferencerVisitorBase {
    private final Map<FunctionStatement, ForwardDeclaration> forwardDeclarations = new IdentityHashMap<FunctionStatement, ForwardDeclaration>();
    private final Stack<Branching> branchings = new Stack();
    public static final TypeInfoModelSwitch<Boolean> GENERIC_TYPE_EXPRESSION = new TypeInfoModelSwitch<Boolean>(){

        @Override
        public Boolean doSwitch(EObject theEObject) {
            return theEObject != null ? (Boolean)super.doSwitch(theEObject) : null;
        }

        @Override
        public Boolean caseJSType(JSType object) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseTypeVariableReference(TypeVariableReference object) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseTypeVariableClassType(TypeVariableClassType object) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean caseArrayType(ArrayType object) {
            return this.doSwitch(object.getItemType());
        }

        @Override
        public Boolean caseMapType(MapType object) {
            Boolean result = this.doSwitch(object.getKeyType());
            if (result == Boolean.TRUE) {
                return result;
            }
            return this.doSwitch(object.getValueType());
        }

        @Override
        public Boolean caseParameterizedType(ParameterizedType object) {
            for (JSType type : object.getActualTypeArguments()) {
                Boolean result = this.doSwitch(type);
                if (result != Boolean.TRUE) continue;
                return result;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseUnionType(UnionType object) {
            for (JSType type : object.getTargets()) {
                Boolean result = this.doSwitch(type);
                if (result != Boolean.TRUE) continue;
                return result;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean caseFunctionType(FunctionType object) {
            for (Parameter parameter : object.getParameters()) {
                Boolean result = this.doSwitch(parameter.getType());
                if (result != Boolean.TRUE) continue;
                return result;
            }
            return this.doSwitch(object.getReturnType());
        }
    };
    protected static final IAssignProtection PROTECT_CONST = new IAssignProtection(){

        @Override
        public IProblemIdentifier problemId() {
            return JavaScriptProblems.REASSIGNMENT_OF_CONSTANT;
        }

        @Override
        public String problemMessage() {
            return ValidationMessages.ReassignmentOfConstant;
        }
    };
    private static final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuilder;

    public TypeInferencerVisitor(ITypeInferenceContext context) {
        super(context);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.forwardDeclarations.clear();
    }

    protected Branching branching() {
        Branching branching = new Branching();
        this.branchings.add(branching);
        return branching;
    }

    @Override
    public ReferenceSource getSource() {
        ReferenceSource source = this.context.getSource();
        return source != null ? source : ReferenceSource.UNKNOWN;
    }

    protected void assign(IValueReference dest, IValueReference src) {
        IRType srcType;
        IRType destType = JavaScriptValidations.typeOf(dest);
        if (destType != null && TypeInferencerVisitor.isXML(destType) && (srcType = JavaScriptValidations.typeOf(src)) != null && !TypeInferencerVisitor.isXML(srcType)) {
            return;
        }
        if (this.branchings.isEmpty()) {
            dest.setValue(src);
        } else {
            dest.addValue(src, false);
        }
    }

    private static boolean isXML(IRType srcType) {
        return srcType instanceof IRSimpleType && ("XML".equals(srcType.getName()) || "XMLList".equals(srcType.getName()));
    }

    public IValueReference visitArrayInitializer(ArrayInitializer node) {
        if (node.getItems().isEmpty()) {
            return new ConstantValue(RTypes.arrayOf());
        }
        HashSet<IRType> types = new HashSet<IRType>();
        for (ASTNode astNode : node.getItems()) {
            IValueReference child;
            if (astNode instanceof StringLiteral) {
                types.add(RTypes.STRING);
                continue;
            }
            if (astNode instanceof DecimalLiteral) {
                types.add(RTypes.NUMBER);
                continue;
            }
            if (astNode instanceof BooleanLiteral) {
                types.add(RTypes.BOOLEAN);
                continue;
            }
            if (astNode instanceof NullExpression || astNode instanceof EmptyExpression || (child = this.visit(astNode)) == null || !child.exists()) continue;
            for (IRType type : JavaScriptValidations.getTypes(child)) {
                if (type == null) {
                    JavaScriptPlugin.error(String.valueOf(this.buildNodeErrorMessage((ASTNode)node)) + " - item type is null");
                    continue;
                }
                types.add(type.normalize());
            }
        }
        if (types.isEmpty()) {
            return new ConstantValue(RTypes.arrayOf());
        }
        if (types.size() == 1) {
            return new ConstantValue(RTypes.arrayOf(this.context, CommonSuperTypeFinder.evaluate(this.context, types)));
        }
        return new ConstantValue(RTypes.arrayOf(this.context, RTypes.union(types)));
    }

    public IValueReference visitAsteriskExpression(AsteriskExpression node) {
        return new XMLListValue(this.peekContext());
    }

    public IValueReference visitBinaryOperation(BinaryOperation node) {
        IValueReference left = this.visit((ASTNode)node.getLeftExpression());
        int op = node.getOperation();
        if (104 == op) {
            if (left != null) {
                IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
                int n = iModelBuilderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelBuilder modelBuilder = iModelBuilderArray[n2];
                    if (modelBuilder instanceof IModelBuilderExtension) {
                        ((IModelBuilderExtension)modelBuilder).processAssignment(node.getLeftExpression(), left);
                    }
                    ++n2;
                }
            }
            if (left != null && left.exists()) {
                IValueReference r;
                if (left.getParent() instanceof ThisValue) {
                    Expression property;
                    Object variable = left.getAttribute("R_VARIABLE");
                    left.getParent().createChild(left.getName());
                    if (variable != null) {
                        left.setAttribute("R_VARIABLE", variable);
                    }
                    if ((property = node.getLeftExpression()) instanceof PropertyExpression) {
                        left.setLocation(ReferenceLocation.create(this.getSource(), property.sourceStart(), property.sourceEnd(), ((PropertyExpression)property).getProperty().sourceStart(), ((PropertyExpression)property).getProperty().sourceEnd()));
                    }
                }
                left.setAttribute("RESOLVING", Boolean.TRUE);
                try {
                    r = this.visit((ASTNode)node.getRightExpression());
                }
                finally {
                    left.setAttribute("RESOLVING", null);
                }
                return this.visitAssign(left, r, node);
            }
            return this.visitAssign(left, this.visit((ASTNode)node.getRightExpression()), node);
        }
        IValueReference right = this.visit((ASTNode)node.getRightExpression());
        if (left == null && right instanceof ConstantValue) {
            return right;
        }
        if (op == 100) {
            return TypeInferencerVisitor.coalesce(right, left);
        }
        if (op == 79 || op == 81 || op == 78 || op == 80 || op == 85 || op == 84 || op == 83 || op == 82) {
            return ConstantValue.of(RTypes.BOOLEAN);
        }
        if (this.isNumber(left) && this.isNumber(right)) {
            return ConstantValue.of(RTypes.NUMBER);
        }
        if (op == 86) {
            if (this.isString(left) || this.isString(right)) {
                return ConstantValue.of(RTypes.STRING);
            }
            return left;
        }
        if (21 == op) {
            return ConstantValue.of(RTypes.BOOLEAN);
        }
        if (101 == op) {
            JSTypeSet typeSet = JSTypeSet.create();
            if (left != null) {
                typeSet.addAll(left.getDeclaredTypes());
                typeSet.addAll(left.getTypes());
            }
            if (right != null) {
                typeSet.addAll(right.getDeclaredTypes());
                typeSet.addAll(right.getTypes());
            }
            return new ConstantValue(typeSet);
        }
        return null;
    }

    private static IValueReference coalesce(IValueReference v1, IValueReference v2) {
        return v1 != null ? v1 : v2;
    }

    private boolean isNumber(IValueReference ref) {
        if (ref != null) {
            if (ref.getTypes().contains(RTypes.NUMBER)) {
                return true;
            }
            if (RTypes.NUMBER.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    private boolean isString(IValueReference ref) {
        if (ref != null) {
            if (ref.getTypes().contains(RTypes.STRING)) {
                return true;
            }
            if (RTypes.STRING.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
        if (left != null) {
            if (node.getLeftExpression() instanceof PropertyExpression) {
                PropertyExpression property = (PropertyExpression)node.getLeftExpression();
                if (property.getProperty() instanceof Identifier && !left.exists()) {
                    if (property.getObject() instanceof ThisExpression) {
                        if (TypeInferencerVisitor.isFunctionDeclaration((Expression)property)) {
                            left.setKind(ReferenceKind.FUNCTION);
                            IValueCollection scope = (IValueCollection)right.getAttribute("FUNCTION_SCOPE");
                            IValueCollection context = this.peekContext();
                            if (scope != null && scope.getThis().getDeclaredType() == null && context instanceof IFunctionValueCollection) {
                                String name = ((IFunctionValueCollection)context).getFunctionName();
                                scope.getThis().setDeclaredType(RTypes.localType(name, context.getParent().getChild(name)));
                            }
                        } else {
                            JSType type;
                            left.setKind(ReferenceKind.FIELD);
                            Comment comment = JSDocSupport.getComment((JSNode)node);
                            JSDocTags tags = this.parseTags(comment);
                            JSDocTag typeTag = tags.get("@type");
                            if (typeTag != null && (type = this.getDocSupport().parseType(typeTag, false, this.getProblemReporter())) != null) {
                                this.setIRType(left, type.toRType(this.context), true);
                            }
                            if (comment != null) {
                                IValueReference namedChild = this.extractNamedChild(left, property.getProperty());
                                String name = namedChild.getName();
                                JSVariable variable = new JSVariable(name);
                                this.getDocSupport().parseAccessModifiers(variable, tags, this.reporter);
                                if (variable.getVisibility() != null) {
                                    left.setAttribute("R_VARIABLE", RModelBuilder.create((ITypeInfoContext)this.context, variable));
                                }
                            }
                        }
                        left.setLocation(ReferenceLocation.create(this.getSource(), property.sourceStart(), property.sourceEnd(), property.getProperty().sourceStart(), property.getProperty().sourceEnd()));
                    } else {
                        IValueReference leftParent = left.getParent();
                        if (leftParent != null) {
                            IRType declaredType = leftParent.getDeclaredType();
                            if (declaredType != null && !declaredType.isExtensible() && !declaredType.isJavaScriptObject()) {
                                return right;
                            }
                            Object attribute = leftParent.getAttribute("ELEMENT");
                            if (attribute instanceof IRProperty && ((IRProperty)attribute).getName().equals("prototype")) {
                                leftParent.getParent().createChild("prototype").setValue(new AnonymousValue());
                            }
                        }
                    }
                } else {
                    Object attribute = left.getAttribute("ELEMENT");
                    if (attribute instanceof IRProperty && ((IRProperty)attribute).getName().equals("prototype")) {
                        left.getParent().createChild("prototype").setValue(new AnonymousValue());
                    }
                }
            }
            if ("[]".equals(left.getName()) && node.getLeftExpression() instanceof GetArrayItemExpression) {
                GetArrayItemExpression arrayItemExpression = (GetArrayItemExpression)node.getLeftExpression();
                IValueReference namedChild = this.extractNamedChild(left.getParent(), arrayItemExpression.getIndex());
                if (namedChild != null) {
                    this.assign(namedChild, right);
                } else {
                    this.assign(left, right);
                }
            } else if (!this.hasUnknowParentFunctionCall(left)) {
                this.assign(left, right);
            }
        }
        return right;
    }

    private boolean hasUnknowParentFunctionCall(IValueReference reference) {
        IValueReference parent = reference.getParent();
        while (parent != null) {
            if (parent.getName().equals("()") && !parent.exists()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public IValueReference visitBooleanLiteral(BooleanLiteral node) {
        return ConstantValue.of(RTypes.BOOLEAN);
    }

    public IValueReference visitBreakStatement(BreakStatement node) {
        return null;
    }

    public IValueReference visitCallExpression(CallExpression node) {
        IValueReference reference = this.visit((ASTNode)node.getExpression());
        List args = node.getArguments();
        IValueReference[] arguments = new IValueReference[args.size()];
        int i = 0;
        while (i < args.size()) {
            arguments[i] = this.visit((ASTNode)args.get(i));
            ++i;
        }
        if (reference != null) {
            List<IRMethod> methods = ValueReferenceUtil.extractElements(reference, IRMethod.class);
            if (methods != null && methods.size() == 1) {
                IRMethod method = methods.get(0);
                IValueReference ref = this.checkSpecialJavascriptFunctionCalls(reference, arguments, method);
                if (ref != null) {
                    return ref;
                }
                if (method.isGeneric()) {
                    IRType type = this.evaluateGenericCall(method, arguments);
                    return ConstantValue.of(type);
                }
                return ConstantValue.of(method.getType());
            }
            IRType expressionType = JavaScriptValidations.typeOf(reference);
            if (expressionType != null) {
                IRConstructor constructor;
                IRTypeDeclaration target;
                if (expressionType instanceof IRFunctionType) {
                    return ConstantValue.of(((IRFunctionType)expressionType).getReturnType());
                }
                if (expressionType instanceof IRClassType && (target = ((IRClassType)expressionType).getDeclaration()) != null && (constructor = target.getStaticConstructor()) != null && constructor.getType() != null) {
                    return new ConstantValue(constructor.getType());
                }
            }
            return reference.getChild("()");
        }
        return null;
    }

    protected IValueReference checkSpecialJavascriptFunctionCalls(IValueReference reference, IValueReference[] arguments, IRMethod method) {
        if (method.getName() != null) {
            if (reference.getParent() != null && RTypes.FUNCTION.getDeclaration().equals(method.getDeclaringType())) {
                if ("call".equals(method.getName()) || "apply".equals(method.getName())) {
                    Object x = reference.getParent().getAttribute("ELEMENT");
                    if (x == null) {
                        x = reference.getParent().getAttribute("R_METHOD");
                    }
                    if (x instanceof IRMethod) {
                        return ConstantValue.of(((IRMethod)x).getType());
                    }
                } else if ("bind".equals(method.getName())) {
                    return reference.getParent();
                }
            } else if (method.getName().equals("create") && RTypes.OBJECT.getDeclaration().equals(method.getDeclaringType()) && arguments.length > 0 && arguments[0] != null) {
                AnonymousValue value = new AnonymousValue();
                IValue argumentValue = ((IValueProvider)((Object)arguments[0])).getValue();
                if (argumentValue != null) {
                    value.getValue().addValue(argumentValue);
                }
                if (arguments.length == 2) {
                    JSTypeSet types = arguments[1].getTypes();
                    for (IRType type : types) {
                        if (!(type instanceof IRRecordType)) continue;
                        ArrayList<IRRecordMember> newMembers = new ArrayList<IRRecordMember>();
                        Collection<IRRecordMember> members = ((IRRecordType)type).getMembers();
                        for (IRRecordMember member : members) {
                            if (member.getType() instanceof IRRecordType) {
                                IRRecordMember valueMember = ((IRRecordType)member.getType()).getMember("value");
                                if (valueMember != null) {
                                    newMembers.add(new RRecordMember(member.getName(), valueMember.getType(), member.getSource()));
                                }
                                if ((valueMember = ((IRRecordType)member.getType()).getMember("get")) == null) continue;
                                IRType valueType = valueMember.getType();
                                if (valueType instanceof IRFunctionType) {
                                    valueType = ((IRFunctionType)valueType).getReturnType();
                                }
                                newMembers.add(new RRecordMember(member.getName(), valueType, valueMember.getSource()));
                                continue;
                            }
                            newMembers.add(member);
                        }
                        if (newMembers.size() <= 0) continue;
                        value.addValue(ConstantValue.of(RTypes.recordType(newMembers)), true);
                    }
                }
                return value;
            }
        }
        return null;
    }

    protected IRType evaluateGenericCall(IRMethod rMethod, IValueReference[] arguments) {
        assert (rMethod.isGeneric());
        GenericMethod method = (GenericMethod)rMethod.getSource();
        GenericMethodTypeInferencer methodTypeInferencer = new GenericMethodTypeInferencer(this.context, method);
        int i = 0;
        while (i < arguments.length) {
            Parameter parameter = method.getParameterFor(i);
            if (parameter != null && TypeUtil.containsTypeVariables(parameter.getType())) {
                JSTypeSet argTypes;
                IValueReference argument = arguments[i];
                if (argument != null) {
                    argTypes = argument.getDeclaredTypes();
                    if (argTypes.isEmpty()) {
                        argTypes = argument.getTypes();
                    }
                } else {
                    argTypes = JSTypeSet.emptySet();
                }
                methodTypeInferencer.capture(parameter.getType(), argTypes);
            }
            ++i;
        }
        return RTypes.create(methodTypeInferencer, method.getType());
    }

    public IValueReference visitCommaExpression(CommaExpression node) {
        return (IValueReference)this.visit(node.getItems());
    }

    public IValueReference visitConditionalOperator(ConditionalOperator node) {
        this.visit((ASTNode)node.getCondition());
        return this.merge(this.visit((ASTNode)node.getTrueValue()), this.visit((ASTNode)node.getFalseValue()));
    }

    public IValueReference visitConstDeclaration(ConstStatement node) {
        IValueCollection context = this.peekContext();
        for (VariableDeclaration declaration : node.getVariables()) {
            IValueReference reference = context.getChild(declaration.getVariableName());
            assert (reference.exists());
            this.initializeVariable(reference, declaration);
        }
        return null;
    }

    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        ISuppressWarningsState state;
        Identifier identifier = declaration.getIdentifier();
        String varName = identifier.getName();
        IValueReference reference = context.createChild(varName);
        JSVariable variable = new JSVariable(declaration.getVariableName());
        Object[] objectArray = this.context.getModelBuilders();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder extension = objectArray[n2];
            extension.processVariable(declaration, variable, this.reporter, this.getTypeChecker());
            ++n2;
        }
        if (this.reporter != null && (state = this.reporter.getSuppressWarnings()) != null) {
            variable.addSuppressedWarning(state.asCategory());
        }
        if (this.listeners != null) {
            objectArray = this.listeners;
            n = this.listeners.length;
            n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                listener.variableParsed(variable);
                ++n2;
            }
        }
        reference.setAttribute("VARIABLE", variable);
        reference.setKind(this.inFunction() ? ReferenceKind.LOCAL : ReferenceKind.GLOBAL);
        reference.setLocation(ReferenceLocation.create(this.getSource(), declaration.sourceStart(), declaration.sourceEnd(), identifier.sourceStart(), identifier.sourceEnd()));
        if (variable.getTypeDef() instanceof RecordType) {
            RecordType type = (RecordType)variable.getTypeDef();
            type.setTypeName(varName);
            this.context.registerRecordType(type);
        }
        return reference;
    }

    protected void initializeVariable(IValueReference reference, VariableDeclaration declaration) {
        if (declaration.getInitializer() != null) {
            IValueReference assignment;
            reference.setAttribute("RESOLVING", Boolean.TRUE);
            try {
                assignment = this.visit((ASTNode)declaration.getInitializer());
            }
            finally {
                reference.setAttribute("RESOLVING", null);
            }
            if (assignment != null) {
                IRVariable variable = (IRVariable)reference.getAttribute("R_VARIABLE");
                if (variable != null && variable.getType() != null) {
                    reference.addValue(assignment, false);
                } else {
                    this.assign(reference, assignment);
                }
                if (assignment.getKind() == ReferenceKind.FUNCTION && reference.getAttribute("METHOD") != null) {
                    reference.setKind(ReferenceKind.FUNCTION);
                }
            }
        }
    }

    public IValueReference visitContinueStatement(ContinueStatement node) {
        return null;
    }

    public IValueReference visitDecimalLiteral(DecimalLiteral node) {
        return ConstantValue.of(RTypes.NUMBER);
    }

    public IValueReference visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        this.visit((ASTNode)node.getValue());
        return null;
    }

    public IValueReference visitDoWhileStatement(DoWhileStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    public IValueReference visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    public IValueReference visitForEachInStatement(ForEachInStatement node) {
        IValueReference itemReference = this.visit((ASTNode)node.getItem());
        IValueReference iteratorReference = this.visit((ASTNode)node.getIterator());
        Set<IRType> typeSet = JavaScriptValidations.getTypes(iteratorReference);
        if (!typeSet.isEmpty()) {
            IRType itemType;
            IRType type = null;
            for (IRType irType : typeSet) {
                IRType itemType2;
                if (type == null) {
                    type = irType;
                    continue;
                }
                if (irType instanceof IRArrayType) {
                    itemType2 = ((IRArrayType)irType).getItemType();
                    if (itemType2 == RTypes.none() || itemType2 == RTypes.any()) continue;
                    type = irType;
                    continue;
                }
                if (!(irType instanceof IRMapType) || (itemType2 = ((IRMapType)irType).getValueType()) == RTypes.none() || itemType2 == RTypes.any()) continue;
                type = irType;
            }
            if (type instanceof IRArrayType && JavaScriptValidations.typeOf(itemReference) == null) {
                itemType = ((IRArrayType)type).getItemType();
                this.setIRType(itemReference, itemType, true);
            } else if (type instanceof IRMapType && JavaScriptValidations.typeOf(itemReference) == null) {
                itemType = ((IRMapType)type).getValueType();
                this.setIRType(itemReference, itemType, true);
            } else if ("XMLList".equals(type.getName())) {
                itemReference.setDeclaredType(E4XTypes.XML);
            }
        }
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForInStatement(ForInStatement node) {
        IValueReference item = this.visit((ASTNode)node.getItem());
        if (item != null) {
            this.assign(item, ConstantValue.of(RTypes.STRING));
        }
        this.visit((ASTNode)node.getIterator());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForStatement(ForStatement node) {
        if (node.getInitial() != null) {
            this.visit((ASTNode)node.getInitial());
        }
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getStep() != null) {
            this.visit((ASTNode)node.getStep());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    private void initializeFunction(JSMethod method, IValueReference function) {
        function.setLocation(method.getLocation());
        function.setKind(ReferenceKind.FUNCTION);
        function.setDeclaredType(RTypes.FUNCTION);
        function.setAttribute("METHOD", method);
        function.setAttribute("RESOLVING", Boolean.TRUE);
    }

    public IValueReference visitFunctionStatement(FunctionStatement node) {
        IValueCollection context;
        BinaryOperation bo;
        IValueReference result;
        JSMethod method;
        ForwardDeclaration forward = this.forwardDeclarations.remove(node);
        if (forward != null) {
            method = forward.method;
            result = forward.reference;
        } else {
            assert (!node.isDeclaration());
            method = this.createMethod(node);
            result = new AnonymousValue();
            this.initializeFunction(method, result);
            result.setAttribute("R_METHOD", RModelBuilder.create((ITypeInfoContext)this.getContext(), method));
        }
        ThisValue thisValue = new ThisValue();
        if (method.getThisType() != null) {
            thisValue.setDeclaredType(this.context.contextualize(method.getThisType()));
        } else if (method.getExtendsType() != null) {
            IRType thisType = this.context.contextualize(method.getExtendsType());
            thisValue.setDeclaredType(thisType);
            if (thisType instanceof IRLocalType) {
                IValueReference prototype = result.createChild("prototype");
                prototype.setDeclaredType(this.context.getType("Object").toRType(this.context));
                Set<String> directChildren = ((IRLocalType)thisType).getDirectChildren();
                for (String child : directChildren) {
                    prototype.createChild(child).setDeclaredType(this.context.getType("Function").toRType(this.context));
                }
            }
        } else if (node.getParent() instanceof BinaryOperation && (bo = (BinaryOperation)node.getParent()).getLeftExpression() instanceof PropertyExpression && ((PropertyExpression)bo.getLeftExpression()).getObject() instanceof ThisExpression && (context = this.peekContext()) instanceof IFunctionValueCollection) {
            String name = ((IFunctionValueCollection)context).getFunctionName();
            thisValue.setDeclaredType(RTypes.localType(name, context.getParent().getChild(name)));
        }
        FunctionValueCollection function = new FunctionValueCollection(this.peekContext(), method.getName(), thisValue, node.isInlineBlock());
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            IValueReference refArg = function.createChild(parameter.getName());
            refArg.setKind(ReferenceKind.ARGUMENT);
            this.setTypeImpl(refArg, parameter.getType());
            refArg.setLocation(parameter.getLocation());
        }
        result.setAttribute("FUNCTION_SCOPE", function);
        this.enterContext(function);
        HashSet suppressed = null;
        try {
            if (this.reporter != null && !method.getSuppressedWarnings().isEmpty()) {
                suppressed = new HashSet();
                for (IProblemCategory category : method.getSuppressedWarnings()) {
                    suppressed.addAll(category.contents());
                }
                this.reporter.pushSuppressWarnings(suppressed);
            }
            this.visitFunctionBody(node);
        }
        finally {
            if (this.reporter != null && suppressed != null) {
                this.reporter.popSuppressWarnings();
            }
            this.leaveContext();
            result.setAttribute("RESOLVING", null);
        }
        IValueReference returnValue = result.getChild("()");
        returnValue.addValue(function.getReturnValue(), true);
        this.setTypeImpl(returnValue, method.getType());
        return result;
    }

    protected JSMethod createMethod(FunctionStatement node) {
        IModelBuilder.IParameter last;
        JSMethod method = new JSMethod(node, this.getSource());
        Object[] objectArray = this.context.getModelBuilders();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder extension = objectArray[n2];
            extension.processMethod(node, method, this.reporter, this.getTypeChecker());
            ++n2;
        }
        if (node.isInlineBlock() && method.getParameterCount() > 0 && (last = method.getParameters().get(method.getParameterCount() - 1)).getType() == null && last.getKind() == ParameterKind.NORMAL && "undefined".equals(last.getName())) {
            last.setKind(ParameterKind.OPTIONAL);
        }
        if (this.listeners != null) {
            objectArray = this.listeners;
            n = this.listeners.length;
            n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                listener.methodParsed(method);
                ++n2;
            }
        }
        return method;
    }

    @Override
    public void visitFunctionBody(FunctionStatement node) {
        this.handleDeclarations((JSScope)node);
        this.visit((ASTNode)node.getBody());
    }

    @Override
    public void setType(IValueReference value, JSType type, boolean lazyEnabled) {
        this.setTypeImpl(value, type, lazyEnabled);
    }

    private void setTypeImpl(IValueReference value, JSType type) {
        this.setTypeImpl(value, type, true);
    }

    private void setTypeImpl(IValueReference value, JSType type, boolean lazyEnabled) {
        if (type == null) {
            return;
        }
        IRType rt = this.context.contextualize(type);
        this.setIRType(value, rt, lazyEnabled);
    }

    private void setIRType(IValueReference value, IRType rt, boolean lazyEnabled) {
        if (rt instanceof IRSimpleType) {
            Type t = ((IRSimpleType)rt).getTarget();
            if (t.getKind() != TypeKind.UNKNOWN) {
                value.setDeclaredType(rt);
                if (value instanceof IValueProvider) {
                    IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
                    int n = iMemberEvaluatorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                        IValueCollection collection = evaluator.valueOf(this.context, t);
                        if (collection != null && collection instanceof IValueProvider) {
                            ((IValueProvider)((Object)value)).getValue().addValue(((IValueProvider)((Object)collection)).getValue());
                        }
                        ++n2;
                    }
                }
            } else if (lazyEnabled) {
                value.addValue(new LazyTypeReference(this.context, t.getName(), this.peekContext()), false);
            }
        } else {
            value.setDeclaredType(rt);
        }
    }

    public IValueReference visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        return new XMLListValue(this.peekContext());
    }

    public IValueReference visitGetArrayItemExpression(GetArrayItemExpression node) {
        IValueReference array = this.visit((ASTNode)node.getArray());
        this.visit((ASTNode)node.getIndex());
        if (array != null) {
            IValueReference namedChild;
            IValueReference child = array.getChild("[]");
            IRType arrayType = null;
            if (array.getDeclaredType() != null) {
                arrayType = TypeUtil.extractArrayItemType(array.getDeclaredType());
            } else {
                JSTypeSet types = array.getTypes();
                if (types.size() > 0) {
                    arrayType = TypeUtil.extractArrayItemType(types.toRType());
                }
            }
            if (arrayType != null && child.getDeclaredType() == null) {
                this.setIRType(child, arrayType, true);
            }
            if (node.getIndex() instanceof StringLiteral && (namedChild = this.extractNamedChild(array, node.getIndex())).exists()) {
                child = namedChild;
                if (arrayType != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(arrayType);
                }
            }
            return child;
        }
        return null;
    }

    public IValueReference visitGetLocalNameExpression(GetLocalNameExpression node) {
        return null;
    }

    public IValueReference visitIdentifier(Identifier node) {
        return this.peekContext().getChild(node.getName());
    }

    private Boolean evaluateCondition(Expression condition) {
        if (condition instanceof BooleanLiteral) {
            return Boolean.valueOf(((BooleanLiteral)condition).getText());
        }
        return null;
    }

    public IValueReference visitIfStatement(IfStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visitIfStatements(node);
        return null;
    }

    protected void visitIfStatements(IfStatement node) {
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        Statement onlyBranch = null;
        Boolean condition = this.evaluateCondition(node.getCondition());
        if ((condition == null || condition.booleanValue()) && node.getThenStatement() != null) {
            statements.add(node.getThenStatement());
            if (condition != null && condition.booleanValue()) {
                onlyBranch = node.getThenStatement();
            }
        }
        if (!(condition != null && condition.booleanValue() || node.getElseStatement() == null)) {
            statements.add(node.getElseStatement());
            if (condition != null && !condition.booleanValue()) {
                onlyBranch = node.getElseStatement();
            }
        }
        if (!statements.isEmpty()) {
            if (statements.size() == 1) {
                if (statements.get(0) == onlyBranch) {
                    this.visit((ASTNode)statements.get(0));
                } else {
                    Branching branching = this.branching();
                    this.visit((ASTNode)statements.get(0));
                    branching.end();
                }
            } else {
                Branching branching = this.branching();
                ArrayList<NestedValueCollection> collections = new ArrayList<NestedValueCollection>(statements.size());
                for (Statement statement : statements) {
                    NestedValueCollection nestedCollection = new NestedValueCollection(this.peekContext());
                    this.enterContext(nestedCollection);
                    this.visit((ASTNode)statement);
                    this.leaveContext();
                    collections.add(nestedCollection);
                }
                NestedValueCollection.mergeTo(this.peekContext(), collections);
                branching.end();
            }
        }
    }

    public IValueReference visitLabelledStatement(LabelledStatement node) {
        if (node.getStatement() != null) {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    protected VisitNewResult visitNew(NewExpression node) {
        VisitNewResult result = new VisitNewResult();
        Expression objectClass = node.getObjectClass();
        if (objectClass instanceof CallExpression) {
            CallExpression call = (CallExpression)objectClass;
            result.arguments = new IValueReference[call.getArguments().size()];
            int index = 0;
            for (ASTNode argument : call.getArguments()) {
                result.arguments[index++] = this.visit(argument);
            }
            objectClass = call.getExpression();
        } else {
            result.arguments = new IValueReference[0];
        }
        result.typeValue = this.visit((ASTNode)objectClass);
        if (result.typeValue != null) {
            if (result.typeValue.getKind() == ReferenceKind.FUNCTION) {
                Object fs = result.typeValue.getAttribute("FUNCTION_SCOPE");
                if (fs instanceof IValueCollection && ((IValueCollection)fs).getThis() != null) {
                    result.value = new AnonymousNewValue();
                    result.value.setValue(((IValueCollection)fs).getThis());
                    result.value.setKind(ReferenceKind.TYPE);
                    String className = PropertyExpressionUtils.getPath((Expression)objectClass);
                    IRMethod method = (IRMethod)result.typeValue.getAttribute("R_METHOD");
                    if (method != null) {
                        String methodName = method.getName();
                        if (className == null || !className.endsWith(methodName)) {
                            className = methodName;
                        }
                    }
                    if (className != null && !className.equals("<anonymous>")) {
                        result.value.setDeclaredType(RTypes.localType(className, result.typeValue));
                    } else {
                        result.value.setDeclaredType(RTypes.OBJECT);
                    }
                }
            } else if (result.typeValue.exists()) {
                for (IRType type : result.typeValue.getDeclaredTypes()) {
                    if (!(type instanceof IRClassType)) continue;
                    result.value = new AnonymousNewValue();
                    result.value.setKind(ReferenceKind.TYPE);
                    result.value.setDeclaredType(((IRClassType)type).newItemType());
                    return result;
                }
                for (IRType type : result.typeValue.getTypes()) {
                    if (!(type instanceof IRClassType)) continue;
                    result.value = new AnonymousNewValue();
                    result.value.setKind(ReferenceKind.TYPE);
                    result.value.setDeclaredType(((IRClassType)type).newItemType());
                    return result;
                }
            }
        }
        if (result.value == null) {
            String className = PropertyExpressionUtils.getPath((Expression)objectClass);
            IValueCollection contextValueCollection = this.peekContext();
            if (className != null) {
                Type knownType = this.context.getKnownType(className, TypeMode.CODE);
                if (knownType != null) {
                    result.value = new AnonymousNewValue();
                    result.value.setValue(new ConstantValue(RTypes.simple(this.context, knownType)));
                    result.value.setKind(ReferenceKind.TYPE);
                } else {
                    result.value = new LazyTypeReference(this.context, className, contextValueCollection);
                }
            } else {
                result.value = new AnonymousNewValue();
                result.value.setValue(ConstantValue.of(RTypes.OBJECT));
            }
        }
        return result;
    }

    public IValueReference visitNewExpression(NewExpression node) {
        return this.visitNew(node).getValue();
    }

    public IValueReference visitNullExpression(NullExpression node) {
        return null;
    }

    public IValueReference visitObjectInitializer(ObjectInitializer node) {
        ArrayList<IRRecordMember> members = new ArrayList<IRRecordMember>(node.getInitializers().size());
        for (ObjectInitializerPart part : node.getInitializers()) {
            JSVariable source;
            IRMethod method;
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            String childName = PropertyExpressionUtils.nameOf((Expression)pi.getName());
            if (childName == null) {
                this.visit((ASTNode)pi.getValue());
                continue;
            }
            JSDocTags tags = this.parseTags(pi.getName().getDocumentation());
            IValueReference value = this.visit((ASTNode)pi.getValue());
            if (value != null && (method = (IRMethod)value.getAttribute("R_METHOD")) != null && (pi.getValue() instanceof FunctionStatement || tags.get("@type") == null)) {
                IRType returnType;
                if (method.getSource() instanceof IModelBuilder.IMethod) {
                    IModelBuilder.IMethod m = (IModelBuilder.IMethod)method.getSource();
                    ReferenceLocation loc = m.getLocation();
                    m.setLocation(ReferenceLocation.create(this.getSource(), loc.getDeclarationStart(), loc.getDeclarationEnd(), pi.getName().sourceStart(), pi.getName().sourceEnd()));
                }
                if ((returnType = method.getType()) == null) {
                    returnType = JavaScriptValidations.typeOf(value.getChild("()"));
                }
                members.add(new RRecordMember(childName, RTypes.functionType(this.context, method.getParameters(), returnType), method.getSource()));
                continue;
            }
            if (!(pi.getValue() instanceof FunctionStatement)) {
                JSDocSupport jsdocSupport;
                source = new JSVariable();
                source.setName(childName);
                source.setLocation(ReferenceLocation.create(this.getSource(), pi.getName().sourceStart(), pi.getName().sourceEnd()));
                if (!tags.isEmpty() && (jsdocSupport = this.getDocSupport()) != null) {
                    jsdocSupport.parseType(source, tags, JSDocSupport.TYPE_TAGS, this.reporter, this.getTypeChecker());
                    jsdocSupport.parseDeprecation(source, tags, this.reporter);
                    jsdocSupport.parseAccessModifiers(source, tags, this.reporter);
                }
            } else {
                source = null;
            }
            IRType type = source != null && source.getType() != null ? RTypes.create(this.context, source.getType()) : JavaScriptValidations.typeOf(value);
            members.add(new RRecordMember(childName, type != null ? type : RTypes.any(), source));
        }
        return ConstantValue.of(RTypes.recordType(members));
    }

    private JSDocTags parseTags(Comment documentation) {
        return documentation != null ? JSDocSupport.parse(documentation) : JSDocTags.EMPTY;
    }

    private JSDocSupport getDocSupport() {
        IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
        int n = iModelBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder modelBuilder = iModelBuilderArray[n2];
            if (modelBuilder instanceof JSDocSupport) {
                return (JSDocSupport)modelBuilder;
            }
            ++n2;
        }
        return null;
    }

    public IValueReference visitParenthesizedExpression(ParenthesizedExpression node) {
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitPropertyExpression(PropertyExpression node) {
        IValueReference object = this.visit((ASTNode)node.getObject());
        return this.extractNamedChild(object, node.getProperty());
    }

    protected IValueReference extractNamedChild(IValueReference parent, Expression name) {
        if (parent != null) {
            String nameStr;
            if (name instanceof Identifier) {
                IValueReference child;
                nameStr = ((Identifier)name).getName();
                IRType parentType = JavaScriptValidations.typeOf(parent);
                if (parentType != null && TypeInferencerVisitor.isXML(parentType) && (child = parent.getChild(nameStr)) != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(E4XTypes.XML);
                    return child;
                }
            } else if (name instanceof StringLiteral) {
                nameStr = ((StringLiteral)name).getValue();
            } else if (name instanceof XmlAttributeIdentifier) {
                if (((XmlAttributeIdentifier)name).getExpression() instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)((XmlAttributeIdentifier)name).getExpression());
                }
                nameStr = ((XmlAttributeIdentifier)name).getAttributeName();
                if (nameStr == null) {
                    return null;
                }
                IValueReference child = parent.getChild(nameStr);
                if (child != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(E4XTypes.XML);
                    return child;
                }
            } else {
                if (name instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)name);
                }
                if (name instanceof ParenthesizedExpression) {
                    this.visitParenthesizedExpression((ParenthesizedExpression)name);
                    return parent;
                }
                return null;
            }
            return parent.getChild(nameStr);
        }
        return null;
    }

    public IValueReference visitRegExpLiteral(RegExpLiteral node) {
        return new ConstantValue(RTypes.REGEXP);
    }

    public IValueReference visitReturnStatement(ReturnStatement node) {
        if (node.getValue() != null) {
            IValueReference returnValue;
            IValueReference value = this.visit((ASTNode)node.getValue());
            if (value != null && (returnValue = this.peekContext().getReturnValue()) != null) {
                returnValue.addValue(value, !(value instanceof LazyTypeReference));
            }
            return value;
        }
        return null;
    }

    public IValueReference visitScript(Script node) {
        this.handleDeclarations((JSScope)node);
        return (IValueReference)this.visit(node.getStatements());
    }

    private void handleDeclarations(JSScope scope) {
        ArrayList<IValueReference> variables = new ArrayList<IValueReference>();
        ArrayList<ForwardDeclaration> forwardDecls = new ArrayList<ForwardDeclaration>();
        IValueCollection context = this.peekContext();
        for (JSDeclaration declaration : scope.getDeclarations()) {
            if (declaration instanceof FunctionStatement) {
                FunctionStatement funcNode = (FunctionStatement)declaration;
                assert (funcNode.isDeclaration());
                JSMethod method = this.createMethod(funcNode);
                IValueReference function = context.createChild(method.getName());
                this.initializeFunction(method, function);
                ForwardDeclaration fd = new ForwardDeclaration(method, function);
                forwardDecls.add(fd);
                this.forwardDeclarations.put(funcNode, fd);
                continue;
            }
            if (!(declaration instanceof VariableDeclaration)) continue;
            VariableDeclaration varDeclaration = (VariableDeclaration)declaration;
            IValueReference var = this.createVariable(context, varDeclaration);
            if (varDeclaration.getParent() instanceof ConstStatement) {
                var.setAttribute(IAssignProtection.ATTRIBUTE, PROTECT_CONST);
            }
            variables.add(var);
        }
        for (ForwardDeclaration decl : forwardDecls) {
            decl.reference.setAttribute("R_METHOD", RModelBuilder.create((ITypeInfoContext)this.getContext(), decl.method));
            if (!decl.method.isConstructor()) continue;
            String name = decl.method.getName();
            if (scope instanceof FunctionStatement) {
                FunctionStatement parent = (FunctionStatement)scope;
                while (parent != null) {
                    if (parent instanceof FunctionStatement) {
                        FunctionStatement fs = parent;
                        if (fs.getName() != null) {
                            name = String.valueOf(fs.getName().getName()) + '.' + name;
                        } else {
                            Expression leftExpression;
                            parent = fs.getParent();
                            if (parent instanceof BinaryOperation && (leftExpression = ((BinaryOperation)parent).getLeftExpression()) instanceof PropertyExpression && ((PropertyExpression)leftExpression).getObject() instanceof ThisExpression && ((PropertyExpression)leftExpression).getProperty() instanceof Identifier) {
                                name = String.valueOf(((Identifier)((PropertyExpression)leftExpression).getProperty()).getName()) + '.' + name;
                            }
                        }
                    }
                    parent = parent.getParent();
                }
            }
            this.context.getType(name);
        }
        for (IValueReference reference : variables) {
            IModelBuilder.IVariable var = (IModelBuilder.IVariable)reference.getAttribute("VARIABLE");
            if (var == null) continue;
            IRVariable rvar = RModelBuilder.create((ITypeInfoContext)this.getContext(), var);
            reference.setAttribute("R_VARIABLE", rvar);
            if (rvar.getType() == null) continue;
            this.setIRType(reference, rvar.getType(), true);
            reference.removeReference(PhantomValueReference.REFERENCE);
        }
    }

    public IValueReference visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public IValueReference visitStringLiteral(StringLiteral node) {
        return ConstantValue.of(RTypes.STRING);
    }

    public IValueReference visitSwitchStatement(SwitchStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        for (SwitchComponent component : node.getCaseClauses()) {
            if (component instanceof CaseClause) {
                this.visit((ASTNode)((CaseClause)component).getCondition());
            }
            this.visit(component.getStatements());
        }
        return null;
    }

    public IValueReference visitThisExpression(ThisExpression node) {
        return this.peekContext().getThis();
    }

    public IValueReference visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit((ASTNode)node.getException());
        }
        return null;
    }

    public IValueReference visitTryStatement(TryStatement node) {
        this.visit((ASTNode)node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            NestedValueCollection collection = new NestedValueCollection(this.peekContext());
            Identifier id = catchClause.getException();
            IValueReference var = collection.createChild(id.getName());
            JSDocTags tags = this.parseTags(id.getDocumentation());
            JSElement variable = new JSElement(id.getName());
            this.getDocSupport().parseType(variable, tags, JSDocSupport.TYPE_TAGS, this.reporter, this.getTypeChecker());
            var.setDeclaredType(variable.getType() != null ? this.context.contextualize(variable.getType()) : RTypes.ERROR);
            this.enterContext(collection);
            if (catchClause.getFilterExpression() != null) {
                this.visit((ASTNode)catchClause.getFilterExpression());
            }
            if (catchClause.getStatement() != null) {
                this.visit((ASTNode)catchClause.getStatement());
            }
            this.leaveContext();
        }
        if (node.getFinally() != null) {
            this.visit((ASTNode)node.getFinally().getStatement());
        }
        return null;
    }

    public IValueReference visitUnaryOperation(UnaryOperation node) {
        if (node.getOperation() == 98) {
            this.visit((ASTNode)node.getExpression());
            return ConstantValue.of(RTypes.BOOLEAN);
        }
        if (node.getOperation() == 12) {
            IValueReference value = this.visit((ASTNode)node.getExpression());
            if (value != null) {
                value.delete(false);
            }
            return ConstantValue.of(RTypes.BOOLEAN);
        }
        if (node.getOperation() == 28) {
            this.visit((ASTNode)node.getExpression());
            return ConstantValue.of(RTypes.STRING);
        }
        if (node.getOperation() == 30) {
            this.visit((ASTNode)node.getExpression());
            return null;
        }
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitVariableStatement(VariableStatement node) {
        IValueCollection collection = this.peekContext();
        IValueReference result = null;
        for (VariableDeclaration declaration : node.getVariables()) {
            result = collection.getChild(declaration.getVariableName());
            assert (result.exists());
            this.initializeVariable(result, declaration);
        }
        return result;
    }

    public IValueReference visitVoidExpression(VoidExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitWhileStatement(WhileStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitWithStatement(WithStatement node) {
        IValueReference with = this.visit((ASTNode)node.getExpression());
        if (with != null) {
            WithValueCollection withCollection = new WithValueCollection(this.peekContext(), with);
            this.enterContext(withCollection);
            this.visit((ASTNode)node.getStatement());
            this.leaveContext();
        } else {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilder == null) {
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        return this.docBuilder;
    }

    public IValueReference visitXmlLiteral(XmlLiteral node) {
        ConstantValue xmlValueReference = new ConstantValue(E4XTypes.XML);
        if (xmlValueReference instanceof IValueProvider) {
            IValue xmlValue = ((IValueProvider)xmlValueReference).getValue();
            List fragments = node.getFragments();
            StringBuilder xml = new StringBuilder();
            for (XmlFragment xmlFragment : fragments) {
                if (xmlFragment instanceof XmlTextFragment) {
                    String xmlText = ((XmlTextFragment)xmlFragment).getXml();
                    if (xmlText.equals("<></>")) continue;
                    if (xmlText.startsWith("<>") && xmlText.endsWith("</>")) {
                        xmlText = "<xml>" + xmlText.substring(2, xmlText.length() - 3) + "</xml>";
                    }
                    xml.append(xmlText);
                    continue;
                }
                if (!(xmlFragment instanceof XmlExpressionFragment)) continue;
                Expression expression = ((XmlExpressionFragment)xmlFragment).getExpression();
                this.visit((ASTNode)expression);
                if (xml.charAt(xml.length() - 1) == '<' || xml.subSequence(xml.length() - 2, xml.length()).equals("</")) {
                    if (expression instanceof Identifier) {
                        xml.append(((Identifier)expression).getName());
                        continue;
                    }
                    xml.setLength(0);
                    break;
                }
                xml.append("\"\" ");
            }
            if (xml.length() > 0) {
                try {
                    DocumentBuilder docBuilder = this.getDocumentBuilder();
                    Document doc = docBuilder.parse(new InputSource(new StringReader(xml.toString())));
                    NodeList nl = doc.getChildNodes();
                    if (nl.getLength() == 1) {
                        Node item = nl.item(0);
                        NamedNodeMap attributes = item.getAttributes();
                        int a = 0;
                        while (a < attributes.getLength()) {
                            Node attribute = attributes.item(a);
                            xmlValue.createChild("@" + attribute.getNodeName(), 0);
                            ++a;
                        }
                        this.createXmlChilds(xmlValue, item.getChildNodes());
                    } else {
                        System.err.println("root should be 1 child?? " + xml);
                    }
                }
                catch (Exception exception) {}
            }
        }
        return xmlValueReference;
    }

    private void createXmlChilds(IValue xmlValue, NodeList nl) {
        int i = 0;
        while (i < nl.getLength()) {
            String value;
            Node item = nl.item(i);
            if (item.getNodeType() != 3 || (value = item.getNodeValue()) != null && !"".equals(value.trim())) {
                IValue nodeValue = xmlValue.createChild(item.getNodeName(), 0);
                nodeValue.setDeclaredType(E4XTypes.XML);
                NamedNodeMap attributes = item.getAttributes();
                if (attributes != null) {
                    int a = 0;
                    while (a < attributes.getLength()) {
                        Node attribute = attributes.item(a);
                        nodeValue.createChild("@" + attribute.getNodeName(), 0);
                        ++a;
                    }
                }
                this.createXmlChilds(nodeValue, item.getChildNodes());
            }
            ++i;
        }
    }

    public IValueReference visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        return new ConstantValue(E4XTypes.XML);
    }

    public IValueReference visitYieldOperator(YieldOperator node) {
        IValueReference reference;
        IValueReference value = this.visit((ASTNode)node.getExpression());
        if (value != null && (reference = this.peekContext().getReturnValue()) != null) {
            reference.addValue(value, true);
        }
        return null;
    }

    public static boolean isFunctionDeclaration(Expression expression) {
        PropertyExpression pe = null;
        if (expression instanceof PropertyExpression) {
            pe = (PropertyExpression)expression;
        } else if (expression.getParent() instanceof PropertyExpression) {
            pe = (PropertyExpression)expression.getParent();
        }
        if (pe != null && pe.getObject() instanceof ThisExpression && pe.getParent() instanceof BinaryOperation) {
            return ((BinaryOperation)pe.getParent()).getRightExpression() instanceof FunctionStatement;
        }
        return false;
    }

    protected static class AnonymousNewValue
    extends AnonymousValue {
        protected AnonymousNewValue() {
        }

        @Override
        public IValueReference getChild(String name) {
            if (name.equals("()")) {
                return this;
            }
            return super.getChild(name);
        }

        @Override
        public void setValue(IValueReference value) {
            if (value instanceof ThisValue) {
                IValue val = this.createValue();
                if (val != null) {
                    val.addValue(((ThisValue)value).getValue());
                }
            } else {
                super.setValue(value);
            }
        }
    }

    private class Branching {
        private Branching() {
        }

        public void end() {
            TypeInferencerVisitor.this.branchings.remove(this);
        }
    }

    private static class ForwardDeclaration {
        final JSMethod method;
        final IValueReference reference;

        public ForwardDeclaration(JSMethod method, IValueReference reference) {
            this.method = method;
            this.reference = reference;
        }
    }

    public static class VisitNewResult {
        IValueReference typeValue;
        IValueReference[] arguments;
        IValueReference value;

        public IValueReference getValue() {
            return this.value;
        }

        public IValueReference getTypeValue() {
            return this.typeValue;
        }

        public IValueReference[] getArguments() {
            return this.arguments;
        }
    }
}

