/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.javascript.internal.corext.codemanipulation.JSCodeGeneration;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.text.JSDocAutoIndentStrategy;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptPartitionScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.dltk.javascript.scriptdoc.JavaHeuristicScanner;
import org.eclipse.dltk.javascript.scriptdoc.JavaIndenter;
import org.eclipse.dltk.javascript.ui.text.IJavaScriptPartitions;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class JavascriptAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartTab;
    private boolean fIsSmartMode;
    private String fPartitioning;
    final IScriptProject fProject;
    JsPreferenceInterpreter prefs;
    static final String C_START = "/*";
    static final String C_END = "*/";

    public JavascriptAutoEditStrategy(String partitioning, IScriptProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
        this.prefs = new JsPreferenceInterpreter(JavaScriptUI.getDefault().getPreferenceStore());
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(String d, int offset, int endOffset, char ch) {
        while (offset < endOffset) {
            char curr = d.charAt(offset);
            if (curr == '\\') {
                ++offset;
            } else if (curr == ch) {
                return offset;
            }
            ++offset;
        }
        return endOffset;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
            JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, true, false, false))) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line = d.getLineOfOffset(p);
            int lineOffset = d.getLineOffset(line);
            if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine <= line) {
                JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            if (this.closeBrace() && this.countBrackets(d.get(), reg.getOffset(), c.offset, false) > 0 && !this.isClosed(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                StringBuffer reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}') {
                int firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start);
                if (firstCharPos != -1 && d.getChar(firstCharPos) == '{') {
                    c.caretOffset = c.offset + buf.length();
                    c.shiftsCaret = false;
                    StringBuffer reference = null;
                    int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                    reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                    buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                    if (reference != null) {
                        buf.append(reference);
                    }
                }
            } else {
                String result;
                IRegion prevLine = d.getLineInformation(line);
                String str = d.get(prevLine.getOffset(), prevLine.getLength());
                if (str.trim().startsWith(C_START) && (result = this.handleJsCodeCompleteStars(str, prevLine, line, d, c)) != null) {
                    buf.setLength(0);
                    buf.append(result);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private String handleJsCodeCompleteStars(String str, IRegion prevLine, int line, IDocument d, DocumentCommand c) {
        int index = str.indexOf(C_START);
        if (str.indexOf(C_END, index + 2) != -1) {
            return null;
        }
        if (prevLine.getOffset() + index < c.offset) {
            StringBuffer buf = new StringBuffer();
            StringBuffer indentStr = new StringBuffer(index);
            int counter = 0;
            while (counter < index) {
                char ch;
                if (Character.isWhitespace(ch = str.charAt(counter++))) {
                    indentStr.append(ch);
                    continue;
                }
                indentStr.append(' ');
            }
            boolean enclosedComment = false;
            try {
                index = line + 1;
                IRegion nextLine = null;
                while ((nextLine = d.getLineInformation(index++)) != null) {
                    String strNextLine = d.get(nextLine.getOffset(), nextLine.getLength());
                    int stComment = strNextLine.indexOf(C_START);
                    int endComment = strNextLine.indexOf(C_END);
                    if (stComment != -1 && endComment != -1) {
                        if (stComment >= endComment) continue;
                    } else if (endComment != -1) {
                        enclosedComment = true;
                    } else if (stComment == -1) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
            String endTag = "\n" + indentStr + " */";
            String generatedString = null;
            if (!enclosedComment && JSDocAutoIndentStrategy.isGenerateStub()) {
                String lineDelimiter;
                try {
                    d.replace(c.offset, 0, endTag);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                c.length = endTag.length();
                IMethod method = JavascriptAutoEditStrategy.findMethod(d, c.offset + endTag.length(), true);
                if (method != null && (generatedString = JSCodeGeneration.getMethodComment(method, null, lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d))) != null) {
                    generatedString = JSDocAutoIndentStrategy.normalizeGeneratedDoc(generatedString);
                    generatedString = JSCodeGeneration.changeIndent(generatedString, 0, method.getScriptProject(), indentStr.toString(), lineDelimiter);
                }
            }
            buf.append("\n" + indentStr + " * ");
            if (generatedString != null) {
                buf.append(generatedString);
            }
            c.caretOffset = c.offset + buf.length();
            c.shiftsCaret = false;
            if (!enclosedComment) {
                buf.append(endTag);
            }
            return buf.toString();
        }
        return null;
    }

    static IMethod findMethod(IDocument document, int offset, boolean reconcile) {
        int len = document.getLength();
        try {
            while (offset < len && Character.isWhitespace(document.getChar(offset))) {
                ++offset;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IModelElement modelElement = EditorUtility.getActiveEditorModelInput();
        if (modelElement != null && modelElement instanceof ISourceModule) {
            IModelElement member;
            ISourceModule module = (ISourceModule)modelElement;
            if (reconcile) {
                try {
                    ScriptModelUtil.reconcile((ISourceModule)module);
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            try {
                member = module.getElementAt(offset);
            }
            catch (ModelException modelException) {
                return null;
            }
            try {
                if (member instanceof IMethod && ((IMethod)member).getSourceRange().getOffset() == offset) {
                    return (IMethod)member;
                }
            }
            catch (ModelException e) {
                JavaScriptUI.log(e);
            }
        }
        return null;
    }

    private boolean isClosed(IDocument d, int offset, int length) {
        int levelAfter;
        String sm = d.get();
        int levelBefore = this.countBrackets(sm, 0, offset, true);
        return levelBefore <= (levelAfter = -this.countBrackets(sm, offset, sm.length(), true));
    }

    /*
     * Enabled aggressive block sorting
     */
    private int countBrackets(String sm, int start, int end, boolean countClose) {
        int level = 0;
        int a = start;
        while (a < end) {
            char charAt = sm.charAt(a);
            block0 : switch (charAt) {
                case '\'': {
                    a = this.getStringEnd(sm, a + 1, end, '\'');
                    break;
                }
                case '\"': {
                    a = this.getStringEnd(sm, a + 1, end, '\"');
                    break;
                }
                case '/': {
                    int aPlus1 = a + 1;
                    if (aPlus1 >= end) break;
                    if (sm.charAt(aPlus1) == '/') {
                        a = sm.indexOf(10, aPlus1);
                        if (a != -1) break;
                        a = sm.length();
                        break;
                    }
                    if (sm.charAt(aPlus1) == '*') {
                        a = sm.indexOf(C_END, aPlus1);
                        if (a == -1) {
                            a = sm.length();
                            break;
                        }
                        ++a;
                        break;
                    }
                    ++aPlus1;
                    while (aPlus1 < end) {
                        char c = sm.charAt(aPlus1);
                        ++aPlus1;
                        if (c == '\\') {
                            ++aPlus1;
                            continue;
                        }
                        if (c == '/') {
                            a = aPlus1;
                            break block0;
                        }
                        if (c != '\n') continue;
                        break block0;
                    }
                    break;
                }
                case '<': {
                    int aPlus1;
                    StringBuilder sb = new StringBuilder(5);
                    sb.append("</");
                    for (aPlus1 = a + 1; aPlus1 < end; ++aPlus1) {
                        int index;
                        char c = sm.charAt(aPlus1);
                        if (Character.isJavaIdentifierPart(c)) {
                            sb.append(c);
                            continue;
                        }
                        if (c != '>' && c != ' ' || sb.length() <= 2) break block0;
                        if (c == '>') {
                            index = sm.substring(aPlus1, end).indexOf(sb.toString());
                            if (index == -1) break block0;
                            a = aPlus1 + index + sb.length();
                            break block0;
                        }
                        while (++aPlus1 < end) {
                            c = sm.charAt(aPlus1);
                            if (c == '/') {
                                if (++aPlus1 >= end) continue;
                                c = sm.charAt(aPlus1);
                                if (c == '>') {
                                    a = aPlus1 + 1;
                                    break block0;
                                }
                                --aPlus1;
                                continue;
                            }
                            if (c == '>') {
                                index = sm.substring(aPlus1, end).indexOf(sb.toString());
                                if (index == -1) break block0;
                                a = aPlus1 + index + sb.length();
                                break block0;
                            }
                            if (c != '\"' && c != '\'' || (index = sm.substring(aPlus1 + 1, end).indexOf(c)) == -1) continue;
                            aPlus1 += index;
                        }
                        break block0;
                    }
                    break;
                }
                case '{': {
                    ++level;
                    break;
                }
                case '}': {
                    if (!countClose) break;
                    --level;
                    break;
                }
            }
            ++a;
        }
        return level;
    }

    private static void installJavaStuff(Document document) {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JavascriptPartitionScanner(), IJavaScriptPartitions.LEGAL_CONTENT_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__javascript_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeJavaStuff(Document document) {
        document.setDocumentPartitioner("__javascript_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            JavaIndenter indenter = new JavaIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            peerOffset = indenter.findReferencePosition(peerOffset);
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            IRegion refLine = document.getLineInformationOfOffset(refOffset);
            String prefix = document.get(refLine.getOffset(), newOffset - refLine.getOffset());
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new JavaHeuristicScanner((IDocument)temp);
            indenter = new JavaIndenter((IDocument)temp, scanner, this.fProject);
            JavascriptAutoEditStrategy.installJavaStuff(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            int tabLength = this.getVisualTabLengthPreference();
            boolean changed = false;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = JavascriptAutoEditStrategy.getCurrentIndent(temp, l);
                        StringBuffer correct = indenter.computeIndentation(lineOffset);
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition, tabLength);
                        if (l != first && temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            JavascriptAutoEditStrategy.removeJavaStuff(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        this.addIndent(temp, l, addition, tabLength);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, tabLength);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private static String getCurrentIndent(Document document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(LINE_COMMENT)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && ((type = TextUtilities.getContentType((IDocument)document, (String)"__javascript_partitioning", (int)to, (boolean)true)).equals("__javascript_doc") || type.equals("__javascript_comment"))) {
            --to;
        }
        return document.get(from, to - from);
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference, int tabLength) {
        int c2;
        int c1 = this.computeVisualLength(correct, tabLength);
        int diff = c1 - (c2 = this.computeVisualLength(current, tabLength));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c, tabLength);
        }
        return diff;
    }

    private void addIndent(Document document, int line, CharSequence indent, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int newInsert = insert;
        while (newInsert < endOffset - 2 && document.get(newInsert, 2).equals(LINE_COMMENT)) {
            newInsert += 2;
        }
        if (newInsert > insert) {
            int whitespaceCount = 0;
            int i = newInsert;
            while (i < endOffset - 1) {
                char ch = document.get(i, 1).charAt(0);
                if (!Character.isWhitespace(ch)) break;
                whitespaceCount += this.computeVisualLength(ch, tabLength);
                ++i;
            }
            if (whitespaceCount != 0 && whitespaceCount >= 4) {
                insert = newInsert;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch, tabLength)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, "");
    }

    private int computeVisualLength(CharSequence seq, int tabLength) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tabLength != 0) {
                    size += tabLength - size % tabLength;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch, int tabLength) {
        if (ch == '\t') {
            return tabLength;
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return 4;
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        JavascriptAutoEditStrategy.installJavaStuff(pasted);
        int firstPeer = command.offset;
        JavaHeuristicScanner pScanner = new JavaHeuristicScanner((IDocument)pasted);
        JavaHeuristicScanner dScanner = new JavaHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block15: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = JavascriptAutoEditStrategy.skipScope(pScanner, pPos, token)) != -1) continue block15;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    JavaIndenter indenter = new JavaIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(JavaHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.startsWith((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
                break;
            }
            case '*': {
                JavascriptAutoEditStrategy.smartCloseJSDoc(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument d, DocumentCommand c) {
        if (c.offset < 4 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 3, 3);
            if (content.equals("els")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(d, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1024 ? this.getIndentOfLine(d, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    static void smartCloseJSDoc(IDocument d, DocumentCommand c) {
        if (c.offset < 3 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 2, 2);
            if (content.equals(C_START)) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int pos = c.offset - 2;
                if ((pos = scanner.findNonWhitespaceBackward(pos - 1, -2)) == -1) {
                    return;
                }
                int prevToken = scanner.previousToken(pos, -2);
                if (prevToken == 1029 || prevToken == 11 && scanner.looksLikeVarStatement(scanner.getPosition())) {
                    c.text = String.valueOf(c.text) + " @type {} */ ";
                    c.shiftsCaret = false;
                    c.caretOffset = c.offset + c.text.indexOf(125);
                } else {
                    pos = scanner.findNonWhitespaceForward(c.offset, -2);
                    if (pos == -1) {
                        return;
                    }
                    int nextToken = scanner.nextToken(pos, -2);
                    if (nextToken == 1032) {
                        c.text = String.valueOf(c.text) + "  */";
                        if (c.offset < d.getLength() && !Character.isWhitespace(d.getChar(c.offset))) {
                            c.text = String.valueOf(c.text) + " ";
                        }
                        c.shiftsCaret = false;
                        c.caretOffset = c.offset + 2;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (!this.fIsSmartTab && this.isRepresentingTab(c.text)) {
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && JavascriptAutoEditStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private boolean isRepresentingTab(String text) {
        if (text == null) {
            return false;
        }
        if (TabStyle.SPACES == this.prefs.getTabStyle()) {
            if (text.length() == 0 || text.length() > this.getVisualTabLengthPreference()) {
                return false;
            }
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) != ' ') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return text.length() == 1 && text.charAt(0) == '\t';
    }

    private static IPreferenceStore getPreferenceStore() {
        return JavaScriptUI.getDefault().getPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void clearCachedValues() {
        this.fCloseBrace = this.prefs.closeBrackets();
        this.fIsSmartTab = this.prefs.isSmartTab();
        this.fIsSmartMode = this.computeSmartMode();
    }

    protected boolean computeSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }
}

