/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.javascript.scriptdoc.IndentManipulation;
import org.eclipse.dltk.javascript.scriptdoc.ScriptdocContentAccess;

public class JSCodeGeneration {
    public static String getMethodComment(IMethod meth, IMethod overridden, String lineDelimiter) {
        String existingComment = null;
        try {
            ISourceRange range = ScriptdocContentAccess.getJavadocRange((IMember)meth);
            if (range != null) {
                ISourceModule compilationUnit = meth.getSourceModule();
                existingComment = compilationUnit.getBuffer().getText(range.getOffset(), range.getLength());
            }
        }
        catch (Exception exception) {}
        StringBuffer buf = new StringBuffer();
        if (existingComment != null && !JSCodeGeneration.isEmptyComment(existingComment)) {
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<Param> paramLines = new ArrayList<Param>();
            int paramStart = -1;
            boolean hasReturn = false;
            StringTokenizer st = new StringTokenizer(existingComment, lineDelimiter);
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                if (line.startsWith("*")) {
                    line = String.valueOf(' ') + line;
                }
                hasReturn = hasReturn || line.indexOf("@return") != -1;
                int index = line.indexOf("@param");
                if (index != -1) {
                    if (paramStart == -1) {
                        paramStart = lines.size() - 1;
                    }
                    Param param = new Param();
                    StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals("@param")) continue;
                        if (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            if (token.startsWith("{") && token.endsWith("}")) {
                                param.type = token;
                                if (tokenizer.hasMoreTokens()) {
                                    param.name = tokenizer.nextToken();
                                }
                            } else {
                                param.name = token;
                            }
                            if (param.name.startsWith("[") && param.name.endsWith("]")) {
                                param.optional = true;
                                param.name = param.name.substring(1, param.name.length() - 1);
                            }
                        }
                        if (!tokenizer.hasMoreTokens()) break;
                        param.doc = tokenizer.nextToken(lineDelimiter).trim();
                        break;
                    }
                    paramLines.add(param);
                    continue;
                }
                lines.add(line);
            }
            int parameterLength = 0;
            try {
                IParameter[] parameters = meth.getParameters();
                parameterLength = parameters.length;
                int paramCounter = 0;
                while (paramCounter < parameterLength) {
                    block34: {
                        IParameter parameter = parameters[paramCounter];
                        int i = 0;
                        while (i < paramLines.size()) {
                            Param param = (Param)paramLines.get(i);
                            if (param.name.equals(parameter.getName())) {
                                if (i != paramCounter) {
                                    paramLines.remove(i);
                                    paramLines.add(paramCounter, param);
                                }
                                break block34;
                            }
                            ++i;
                        }
                        paramLines.add(new Param(parameter.getName(), "{Object}"));
                        --paramCounter;
                    }
                    ++paramCounter;
                }
            }
            catch (ModelException modelException) {}
            if (paramStart == -1) {
                paramStart = lines.size() - 2;
            }
            int i = 0;
            while (i < lines.size()) {
                buf.append((String)lines.get(i)).append(lineDelimiter);
                if (paramStart == i) {
                    boolean optional = false;
                    int j = 0;
                    while (j < parameterLength) {
                        Param param = (Param)paramLines.get(j);
                        if (!optional) {
                            optional = param.optional;
                        }
                        param.optional = optional;
                        buf.append(param).append(lineDelimiter);
                        ++j;
                    }
                    if (!hasReturn) {
                        try {
                            if (meth.getType() != null) {
                                buf.append(" * @return {");
                                buf.append(meth.getType());
                                buf.append("}").append(lineDelimiter);
                            }
                        }
                        catch (ModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        } else {
            buf.append("/**").append(lineDelimiter);
            try {
                IParameter[] iParameterArray = meth.getParameters();
                int n = iParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameter parameter = iParameterArray[n2];
                    buf.append(" * @param {Object} " + parameter.getName()).append(lineDelimiter);
                    ++n2;
                }
                if (meth.getType() != null) {
                    buf.append(" * @return {");
                    buf.append(meth.getType());
                    buf.append("}").append(lineDelimiter);
                }
            }
            catch (ModelException modelException) {}
            buf.append(" */").append(lineDelimiter);
        }
        return buf.toString();
    }

    public static String getFieldComment(ISourceModule sourceModule, String typeName, String fieldName, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        buf.append("/**").append(lineDelimiter);
        buf.append(" * " + fieldName).append(lineDelimiter);
        buf.append(" * @type ").append("{").append(typeName != null ? typeName : "Object").append("}").append(lineDelimiter);
        buf.append(" */").append(lineDelimiter);
        return buf.toString();
    }

    public static String getTypeComment(ISourceModule sourceModule, String typeQualifiedName, String[] typeParameterNames, String lineDelimiter) {
        return null;
    }

    public static String getIndentString(String line, IScriptProject project) {
        return IndentManipulation.extractIndentString(line, JSCodeGeneration.getTabWidth(project), JSCodeGeneration.getIndentWidth(project));
    }

    public static int getTabWidth(IScriptProject project) {
        PreferencesLookupDelegate prefs = new PreferencesLookupDelegate(project);
        String key = "space".equals(prefs.getString("org.eclipse.dltk.javascript.ui", "formatter.tabulation.char")) ? "formatter.indentation.size" : "formatter.tabulation.size";
        return prefs.getInt("org.eclipse.dltk.javascript.ui", key);
    }

    public static int getIndentWidth(IScriptProject project) {
        PreferencesLookupDelegate prefs = new PreferencesLookupDelegate(project);
        String key = "mixed".equals(prefs.getString("org.eclipse.dltk.javascript.ui", "formatter.tabulation.char")) ? "formatter.indentation.size" : "formatter.tabulation.size";
        return prefs.getInt("org.eclipse.dltk.javascript.ui", key);
    }

    public static String changeIndent(String code, int codeIndentLevel, IScriptProject project, String newIndent, String lineDelim) {
        return IndentManipulation.changeIndent(code, codeIndentLevel, JSCodeGeneration.getTabWidth(project), JSCodeGeneration.getIndentWidth(project), newIndent, lineDelim);
    }

    private static boolean isEmptyComment(String comment) {
        int begin = 0;
        int end = comment.length();
        while (begin < end && Character.isWhitespace(comment.charAt(begin))) {
            ++begin;
        }
        if (begin < end && comment.charAt(begin) == '/') {
            ++begin;
        }
        while (begin < end && Character.isWhitespace(comment.charAt(end - 1))) {
            --end;
        }
        if (begin < end && comment.charAt(end - 1) == '/') {
            --end;
        }
        while (begin < end && (Character.isWhitespace(comment.charAt(begin)) || comment.charAt(begin) == '*')) {
            ++begin;
        }
        return begin >= end;
    }

    private static class Param {
        private String name;
        private boolean optional;
        private String type;
        private String doc;

        public Param() {
        }

        public Param(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return " * @param " + (this.type != null ? String.valueOf(this.type) + " " : "") + (this.optional ? "[" + this.name + "]" : this.name) + (this.doc != null ? " " + this.doc : "");
        }
    }
}

