/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.util.HashMap;
import org.eclipse.dltk.rhino.dbgp.Base64Helper;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugFrame;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugger;

final class PropertySetCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger debugger;

    PropertySetCommand(DBGPDebugger debugger) {
        this.debugger = debugger;
    }

    void parseAndExecute(String command, HashMap options) {
        String name = (String)options.get("-n");
        int num = Integer.parseInt((String)options.get("-d"));
        String value = Base64Helper.decodeString((String)options.get("--"));
        if (num >= 0) {
            DBGPDebugFrame fr = this.debugger.stackmanager.getStackFrame(num);
            fr.setValue(name, value);
        } else {
            boolean parseBoolean;
            if (name.equals("suspendOnEntry")) {
                parseBoolean = new Boolean(value);
                this.debugger.setSuspendOnEntry(parseBoolean);
            }
            if (name.equals("suspendOnExit")) {
                parseBoolean = new Boolean(value);
                this.debugger.setSuspendOnExit(parseBoolean);
            }
            this.debugger.setProperty(name, value);
        }
        this.debugger.printResponse("<response command=\"property_set\"\r\n transaction_id=\"" + options.get("-i") + "\" success=\"1\" " + ">\r\n" + "</response>\r\n");
    }
}

