/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.StringLiteral;

public class PropertyInitializer
extends ObjectInitializerPart
implements ISourceable {
    private Expression name;
    private Expression value;
    private int colon = -1;

    public PropertyInitializer(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.name != null) {
                this.name.traverse(visitor);
            }
            if (this.value != null) {
                this.value.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public int getColon() {
        return this.colon;
    }

    public void setColon(int colon) {
        this.colon = colon;
    }

    @Override
    public String toSourceString(String indentationString) {
        return String.valueOf(PropertyInitializer.toSourceString(this.name, indentationString)) + ": " + PropertyInitializer.toSourceString(this.value, indentationString);
    }

    public String getNameAsString() {
        Expression name = this.getName();
        if (name instanceof Identifier) {
            return ((Identifier)name).getName();
        }
        if (name instanceof StringLiteral) {
            return ((StringLiteral)name).getValue();
        }
        return null;
    }
}

