/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.index.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.index.sql.IContainerDao;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.IFileDao;
import org.eclipse.dltk.core.index.sql.SqlIndex;

public abstract class DbFactory {
    private static final String EXTPOINT = "org.eclipse.dltk.core.index.sql.dbFactory";
    private static final String FACTORY_ELEM = "factory";
    private static final String CLASS_ATTR = "class";
    private static ILock instanceLock = Job.getJobManager().newLock();
    private static DbFactory instance;

    public static DbFactory getInstance() {
        block8: {
            if (instance == null) {
                try {
                    instanceLock.acquire();
                    if (instance != null) break block8;
                    try {
                        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPOINT);
                        int n = iConfigurationElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            if (FACTORY_ELEM.equals(element.getName())) {
                                instance = (DbFactory)element.createExecutableExtension(CLASS_ATTR);
                                SqlIndex.addShutdownListener(new IShutdownListener(){

                                    public void shutdown() {
                                        if (instance != null) {
                                            try {
                                                instance.dispose();
                                            }
                                            catch (SQLException e) {
                                                SqlIndex.error("DbFactory.dispose() error", e);
                                            }
                                            instance = null;
                                        }
                                    }
                                });
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        SqlIndex.error("An exception has occurred while creating database factory", e);
                    }
                }
                finally {
                    instanceLock.release();
                }
            }
        }
        return instance;
    }

    public abstract Connection createConnection() throws SQLException;

    public abstract void dispose() throws SQLException;

    public abstract IElementDao getElementDao();

    public abstract IFileDao getFileDao();

    public abstract IContainerDao getContainerDao();
}

