/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.compiler.task.TaskTagUtils;
import org.eclipse.dltk.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclPreferencesMessages;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TclCheckContentExcludeInputDialog
extends StatusDialog
implements IDialogFieldListener {
    private StringDialogField fPatternDialogField;
    private final List fExistingNames;

    public TclCheckContentExcludeInputDialog(Shell parent, String input, List existingEntries) {
        super(parent);
        this.fExistingNames = existingEntries;
        if (input == null) {
            this.setTitle(TclPreferencesMessages.TclCheckContentExcludeDialog_newTitle);
        } else {
            this.setTitle(TclPreferencesMessages.TclCheckContentExcludeDialog_editTitle);
        }
        this.fPatternDialogField = new StringDialogField();
        this.fPatternDialogField.setLabelText(TclPreferencesMessages.TclCheckContentExcludeDialog_pattern);
        this.fPatternDialogField.setDialogFieldListener((IDialogFieldListener)this);
        this.fPatternDialogField.setText(input != null ? input : "");
    }

    public String getResult() {
        return this.fPatternDialogField.getText().trim();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fPatternDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fPatternDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fPatternDialogField.getTextControl(null), (int)this.convertWidthInCharsToPixels(45));
        this.fPatternDialogField.postSetFocusOnDialogField(parent.getDisplay());
        TclCheckContentExcludeInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fPatternDialogField.getText();
        if (newText.length() == 0) {
            status.setError(TclPreferencesMessages.TclCheckContentExcludeDialog_enterPatternError);
        } else if (!TaskTagUtils.isValidName((String)newText)) {
            status.setError(TclPreferencesMessages.TclCheckContentExcludeDialog_invalidPatternError);
        } else if (this.fExistingNames.contains(newText)) {
            status.setError(TclPreferencesMessages.TclCheckContentExcludeDialog_duplicatePatternError);
        }
        this.updateStatus((IStatus)status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public void dialogFieldChanged(DialogField field) {
        this.doValidation();
    }
}

